/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAppResponse extends AbstractModel {

    /**
    * Application ID.
    */
    @SerializedName("AppBizId")
    @Expose
    private String AppBizId;

    /**
    * Application type; knowledge_qa - knowledge Q&A management; summary - knowledge summary; classifys - knowledge label extraction.
    */
    @SerializedName("AppType")
    @Expose
    private String AppType;

    /**
    * Application type description.
    */
    @SerializedName("AppTypeDesc")
    @Expose
    private String AppTypeDesc;

    /**
    * Application type description.
    */
    @SerializedName("BaseConfig")
    @Expose
    private BaseConfig BaseConfig;

    /**
    * Application configuration.
    */
    @SerializedName("AppConfig")
    @Expose
    private AppConfig AppConfig;

    /**
    * Whether the avatar is under appeal.
    */
    @SerializedName("AvatarInAppeal")
    @Expose
    private Boolean AvatarInAppeal;

    /**
    * Whether the role description is under appeal.
    */
    @SerializedName("RoleInAppeal")
    @Expose
    private Boolean RoleInAppeal;

    /**
    * Whether the name is under appeal.
    */
    @SerializedName("NameInAppeal")
    @Expose
    private Boolean NameInAppeal;

    /**
    * Whether the welcome words are under appeal.
    */
    @SerializedName("GreetingInAppeal")
    @Expose
    private Boolean GreetingInAppeal;

    /**
    * Whether the response message for unknown questions is under appeal.
    */
    @SerializedName("BareAnswerInAppeal")
    @Expose
    private Boolean BareAnswerInAppeal;

    /**
    * App key of the application.
    */
    @SerializedName("AppKey")
    @Expose
    private String AppKey;

    /**
    * Application status. 1: offline; 2: running; 3: disabled.
    */
    @SerializedName("AppStatus")
    @Expose
    private Long AppStatus;

    /**
    * Status description.
    */
    @SerializedName("AppStatusDesc")
    @Expose
    private String AppStatusDesc;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Application ID. 
     * @return AppBizId Application ID.
     */
    public String getAppBizId() {
        return this.AppBizId;
    }

    /**
     * Set Application ID.
     * @param AppBizId Application ID.
     */
    public void setAppBizId(String AppBizId) {
        this.AppBizId = AppBizId;
    }

    /**
     * Get Application type; knowledge_qa - knowledge Q&A management; summary - knowledge summary; classifys - knowledge label extraction. 
     * @return AppType Application type; knowledge_qa - knowledge Q&A management; summary - knowledge summary; classifys - knowledge label extraction.
     */
    public String getAppType() {
        return this.AppType;
    }

    /**
     * Set Application type; knowledge_qa - knowledge Q&A management; summary - knowledge summary; classifys - knowledge label extraction.
     * @param AppType Application type; knowledge_qa - knowledge Q&A management; summary - knowledge summary; classifys - knowledge label extraction.
     */
    public void setAppType(String AppType) {
        this.AppType = AppType;
    }

    /**
     * Get Application type description. 
     * @return AppTypeDesc Application type description.
     */
    public String getAppTypeDesc() {
        return this.AppTypeDesc;
    }

    /**
     * Set Application type description.
     * @param AppTypeDesc Application type description.
     */
    public void setAppTypeDesc(String AppTypeDesc) {
        this.AppTypeDesc = AppTypeDesc;
    }

    /**
     * Get Application type description. 
     * @return BaseConfig Application type description.
     */
    public BaseConfig getBaseConfig() {
        return this.BaseConfig;
    }

    /**
     * Set Application type description.
     * @param BaseConfig Application type description.
     */
    public void setBaseConfig(BaseConfig BaseConfig) {
        this.BaseConfig = BaseConfig;
    }

    /**
     * Get Application configuration. 
     * @return AppConfig Application configuration.
     */
    public AppConfig getAppConfig() {
        return this.AppConfig;
    }

    /**
     * Set Application configuration.
     * @param AppConfig Application configuration.
     */
    public void setAppConfig(AppConfig AppConfig) {
        this.AppConfig = AppConfig;
    }

    /**
     * Get Whether the avatar is under appeal. 
     * @return AvatarInAppeal Whether the avatar is under appeal.
     */
    public Boolean getAvatarInAppeal() {
        return this.AvatarInAppeal;
    }

    /**
     * Set Whether the avatar is under appeal.
     * @param AvatarInAppeal Whether the avatar is under appeal.
     */
    public void setAvatarInAppeal(Boolean AvatarInAppeal) {
        this.AvatarInAppeal = AvatarInAppeal;
    }

    /**
     * Get Whether the role description is under appeal. 
     * @return RoleInAppeal Whether the role description is under appeal.
     */
    public Boolean getRoleInAppeal() {
        return this.RoleInAppeal;
    }

    /**
     * Set Whether the role description is under appeal.
     * @param RoleInAppeal Whether the role description is under appeal.
     */
    public void setRoleInAppeal(Boolean RoleInAppeal) {
        this.RoleInAppeal = RoleInAppeal;
    }

    /**
     * Get Whether the name is under appeal. 
     * @return NameInAppeal Whether the name is under appeal.
     */
    public Boolean getNameInAppeal() {
        return this.NameInAppeal;
    }

    /**
     * Set Whether the name is under appeal.
     * @param NameInAppeal Whether the name is under appeal.
     */
    public void setNameInAppeal(Boolean NameInAppeal) {
        this.NameInAppeal = NameInAppeal;
    }

    /**
     * Get Whether the welcome words are under appeal. 
     * @return GreetingInAppeal Whether the welcome words are under appeal.
     */
    public Boolean getGreetingInAppeal() {
        return this.GreetingInAppeal;
    }

    /**
     * Set Whether the welcome words are under appeal.
     * @param GreetingInAppeal Whether the welcome words are under appeal.
     */
    public void setGreetingInAppeal(Boolean GreetingInAppeal) {
        this.GreetingInAppeal = GreetingInAppeal;
    }

    /**
     * Get Whether the response message for unknown questions is under appeal. 
     * @return BareAnswerInAppeal Whether the response message for unknown questions is under appeal.
     */
    public Boolean getBareAnswerInAppeal() {
        return this.BareAnswerInAppeal;
    }

    /**
     * Set Whether the response message for unknown questions is under appeal.
     * @param BareAnswerInAppeal Whether the response message for unknown questions is under appeal.
     */
    public void setBareAnswerInAppeal(Boolean BareAnswerInAppeal) {
        this.BareAnswerInAppeal = BareAnswerInAppeal;
    }

    /**
     * Get App key of the application. 
     * @return AppKey App key of the application.
     */
    public String getAppKey() {
        return this.AppKey;
    }

    /**
     * Set App key of the application.
     * @param AppKey App key of the application.
     */
    public void setAppKey(String AppKey) {
        this.AppKey = AppKey;
    }

    /**
     * Get Application status. 1: offline; 2: running; 3: disabled. 
     * @return AppStatus Application status. 1: offline; 2: running; 3: disabled.
     */
    public Long getAppStatus() {
        return this.AppStatus;
    }

    /**
     * Set Application status. 1: offline; 2: running; 3: disabled.
     * @param AppStatus Application status. 1: offline; 2: running; 3: disabled.
     */
    public void setAppStatus(Long AppStatus) {
        this.AppStatus = AppStatus;
    }

    /**
     * Get Status description. 
     * @return AppStatusDesc Status description.
     */
    public String getAppStatusDesc() {
        return this.AppStatusDesc;
    }

    /**
     * Set Status description.
     * @param AppStatusDesc Status description.
     */
    public void setAppStatusDesc(String AppStatusDesc) {
        this.AppStatusDesc = AppStatusDesc;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAppResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAppResponse(DescribeAppResponse source) {
        if (source.AppBizId != null) {
            this.AppBizId = new String(source.AppBizId);
        }
        if (source.AppType != null) {
            this.AppType = new String(source.AppType);
        }
        if (source.AppTypeDesc != null) {
            this.AppTypeDesc = new String(source.AppTypeDesc);
        }
        if (source.BaseConfig != null) {
            this.BaseConfig = new BaseConfig(source.BaseConfig);
        }
        if (source.AppConfig != null) {
            this.AppConfig = new AppConfig(source.AppConfig);
        }
        if (source.AvatarInAppeal != null) {
            this.AvatarInAppeal = new Boolean(source.AvatarInAppeal);
        }
        if (source.RoleInAppeal != null) {
            this.RoleInAppeal = new Boolean(source.RoleInAppeal);
        }
        if (source.NameInAppeal != null) {
            this.NameInAppeal = new Boolean(source.NameInAppeal);
        }
        if (source.GreetingInAppeal != null) {
            this.GreetingInAppeal = new Boolean(source.GreetingInAppeal);
        }
        if (source.BareAnswerInAppeal != null) {
            this.BareAnswerInAppeal = new Boolean(source.BareAnswerInAppeal);
        }
        if (source.AppKey != null) {
            this.AppKey = new String(source.AppKey);
        }
        if (source.AppStatus != null) {
            this.AppStatus = new Long(source.AppStatus);
        }
        if (source.AppStatusDesc != null) {
            this.AppStatusDesc = new String(source.AppStatusDesc);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AppBizId", this.AppBizId);
        this.setParamSimple(map, prefix + "AppType", this.AppType);
        this.setParamSimple(map, prefix + "AppTypeDesc", this.AppTypeDesc);
        this.setParamObj(map, prefix + "BaseConfig.", this.BaseConfig);
        this.setParamObj(map, prefix + "AppConfig.", this.AppConfig);
        this.setParamSimple(map, prefix + "AvatarInAppeal", this.AvatarInAppeal);
        this.setParamSimple(map, prefix + "RoleInAppeal", this.RoleInAppeal);
        this.setParamSimple(map, prefix + "NameInAppeal", this.NameInAppeal);
        this.setParamSimple(map, prefix + "GreetingInAppeal", this.GreetingInAppeal);
        this.setParamSimple(map, prefix + "BareAnswerInAppeal", this.BareAnswerInAppeal);
        this.setParamSimple(map, prefix + "AppKey", this.AppKey);
        this.setParamSimple(map, prefix + "AppStatus", this.AppStatus);
        this.setParamSimple(map, prefix + "AppStatusDesc", this.AppStatusDesc);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

