/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAttributeLabelResponse extends AbstractModel {

    /**
    * Attribute ID.
    */
    @SerializedName("AttributeBizId")
    @Expose
    private String AttributeBizId;

    /**
    * Attribute identifier.
    */
    @SerializedName("AttrKey")
    @Expose
    private String AttrKey;

    /**
    * Attribute name.
    */
    @SerializedName("AttrName")
    @Expose
    private String AttrName;

    /**
    * Quantity of labels.
    */
    @SerializedName("LabelNumber")
    @Expose
    private String LabelNumber;

    /**
    * Label name.
    */
    @SerializedName("Labels")
    @Expose
    private AttributeLabel [] Labels;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Attribute ID. 
     * @return AttributeBizId Attribute ID.
     */
    public String getAttributeBizId() {
        return this.AttributeBizId;
    }

    /**
     * Set Attribute ID.
     * @param AttributeBizId Attribute ID.
     */
    public void setAttributeBizId(String AttributeBizId) {
        this.AttributeBizId = AttributeBizId;
    }

    /**
     * Get Attribute identifier. 
     * @return AttrKey Attribute identifier.
     */
    public String getAttrKey() {
        return this.AttrKey;
    }

    /**
     * Set Attribute identifier.
     * @param AttrKey Attribute identifier.
     */
    public void setAttrKey(String AttrKey) {
        this.AttrKey = AttrKey;
    }

    /**
     * Get Attribute name. 
     * @return AttrName Attribute name.
     */
    public String getAttrName() {
        return this.AttrName;
    }

    /**
     * Set Attribute name.
     * @param AttrName Attribute name.
     */
    public void setAttrName(String AttrName) {
        this.AttrName = AttrName;
    }

    /**
     * Get Quantity of labels. 
     * @return LabelNumber Quantity of labels.
     */
    public String getLabelNumber() {
        return this.LabelNumber;
    }

    /**
     * Set Quantity of labels.
     * @param LabelNumber Quantity of labels.
     */
    public void setLabelNumber(String LabelNumber) {
        this.LabelNumber = LabelNumber;
    }

    /**
     * Get Label name. 
     * @return Labels Label name.
     */
    public AttributeLabel [] getLabels() {
        return this.Labels;
    }

    /**
     * Set Label name.
     * @param Labels Label name.
     */
    public void setLabels(AttributeLabel [] Labels) {
        this.Labels = Labels;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAttributeLabelResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAttributeLabelResponse(DescribeAttributeLabelResponse source) {
        if (source.AttributeBizId != null) {
            this.AttributeBizId = new String(source.AttributeBizId);
        }
        if (source.AttrKey != null) {
            this.AttrKey = new String(source.AttrKey);
        }
        if (source.AttrName != null) {
            this.AttrName = new String(source.AttrName);
        }
        if (source.LabelNumber != null) {
            this.LabelNumber = new String(source.LabelNumber);
        }
        if (source.Labels != null) {
            this.Labels = new AttributeLabel[source.Labels.length];
            for (int i = 0; i < source.Labels.length; i++) {
                this.Labels[i] = new AttributeLabel(source.Labels[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AttributeBizId", this.AttributeBizId);
        this.setParamSimple(map, prefix + "AttrKey", this.AttrKey);
        this.setParamSimple(map, prefix + "AttrName", this.AttrName);
        this.setParamSimple(map, prefix + "LabelNumber", this.LabelNumber);
        this.setParamArrayObj(map, prefix + "Labels.", this.Labels);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

