/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeConcurrencyUsageGraphResponse extends AbstractModel {

    /**
    * X-axis: time zone; returns two interval ranges of "minute/hour/day" according to the granularity of query conditions.
    */
    @SerializedName("X")
    @Expose
    private String [] X;

    /**
    * Available concurrent Y-axis coordinate.
    */
    @SerializedName("AvailableY")
    @Expose
    private Long [] AvailableY;

    /**
    * Succeeded to call the concurrent Y-axis coordinate.
    */
    @SerializedName("SuccessCallY")
    @Expose
    private Long [] SuccessCallY;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get X-axis: time zone; returns two interval ranges of "minute/hour/day" according to the granularity of query conditions. 
     * @return X X-axis: time zone; returns two interval ranges of "minute/hour/day" according to the granularity of query conditions.
     */
    public String [] getX() {
        return this.X;
    }

    /**
     * Set X-axis: time zone; returns two interval ranges of "minute/hour/day" according to the granularity of query conditions.
     * @param X X-axis: time zone; returns two interval ranges of "minute/hour/day" according to the granularity of query conditions.
     */
    public void setX(String [] X) {
        this.X = X;
    }

    /**
     * Get Available concurrent Y-axis coordinate. 
     * @return AvailableY Available concurrent Y-axis coordinate.
     */
    public Long [] getAvailableY() {
        return this.AvailableY;
    }

    /**
     * Set Available concurrent Y-axis coordinate.
     * @param AvailableY Available concurrent Y-axis coordinate.
     */
    public void setAvailableY(Long [] AvailableY) {
        this.AvailableY = AvailableY;
    }

    /**
     * Get Succeeded to call the concurrent Y-axis coordinate. 
     * @return SuccessCallY Succeeded to call the concurrent Y-axis coordinate.
     */
    public Long [] getSuccessCallY() {
        return this.SuccessCallY;
    }

    /**
     * Set Succeeded to call the concurrent Y-axis coordinate.
     * @param SuccessCallY Succeeded to call the concurrent Y-axis coordinate.
     */
    public void setSuccessCallY(Long [] SuccessCallY) {
        this.SuccessCallY = SuccessCallY;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeConcurrencyUsageGraphResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeConcurrencyUsageGraphResponse(DescribeConcurrencyUsageGraphResponse source) {
        if (source.X != null) {
            this.X = new String[source.X.length];
            for (int i = 0; i < source.X.length; i++) {
                this.X[i] = new String(source.X[i]);
            }
        }
        if (source.AvailableY != null) {
            this.AvailableY = new Long[source.AvailableY.length];
            for (int i = 0; i < source.AvailableY.length; i++) {
                this.AvailableY[i] = new Long(source.AvailableY[i]);
            }
        }
        if (source.SuccessCallY != null) {
            this.SuccessCallY = new Long[source.SuccessCallY.length];
            for (int i = 0; i < source.SuccessCallY.length; i++) {
                this.SuccessCallY[i] = new Long(source.SuccessCallY[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "X.", this.X);
        this.setParamArraySimple(map, prefix + "AvailableY.", this.AvailableY);
        this.setParamArraySimple(map, prefix + "SuccessCallY.", this.SuccessCallY);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

