/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeConcurrencyUsageResponse extends AbstractModel {

    /**
    * The upper limit of available concurrency.
    */
    @SerializedName("AvailableConcurrency")
    @Expose
    private Long AvailableConcurrency;

    /**
    * Peak concurrent value.
    */
    @SerializedName("ConcurrencyPeak")
    @Expose
    private Long ConcurrencyPeak;

    /**
    * The number of times exceeding the capacity limit of available concurrency.
    */
    @SerializedName("ExceedUsageTime")
    @Expose
    private Long ExceedUsageTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get The upper limit of available concurrency. 
     * @return AvailableConcurrency The upper limit of available concurrency.
     */
    public Long getAvailableConcurrency() {
        return this.AvailableConcurrency;
    }

    /**
     * Set The upper limit of available concurrency.
     * @param AvailableConcurrency The upper limit of available concurrency.
     */
    public void setAvailableConcurrency(Long AvailableConcurrency) {
        this.AvailableConcurrency = AvailableConcurrency;
    }

    /**
     * Get Peak concurrent value. 
     * @return ConcurrencyPeak Peak concurrent value.
     */
    public Long getConcurrencyPeak() {
        return this.ConcurrencyPeak;
    }

    /**
     * Set Peak concurrent value.
     * @param ConcurrencyPeak Peak concurrent value.
     */
    public void setConcurrencyPeak(Long ConcurrencyPeak) {
        this.ConcurrencyPeak = ConcurrencyPeak;
    }

    /**
     * Get The number of times exceeding the capacity limit of available concurrency. 
     * @return ExceedUsageTime The number of times exceeding the capacity limit of available concurrency.
     */
    public Long getExceedUsageTime() {
        return this.ExceedUsageTime;
    }

    /**
     * Set The number of times exceeding the capacity limit of available concurrency.
     * @param ExceedUsageTime The number of times exceeding the capacity limit of available concurrency.
     */
    public void setExceedUsageTime(Long ExceedUsageTime) {
        this.ExceedUsageTime = ExceedUsageTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeConcurrencyUsageResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeConcurrencyUsageResponse(DescribeConcurrencyUsageResponse source) {
        if (source.AvailableConcurrency != null) {
            this.AvailableConcurrency = new Long(source.AvailableConcurrency);
        }
        if (source.ConcurrencyPeak != null) {
            this.ConcurrencyPeak = new Long(source.ConcurrencyPeak);
        }
        if (source.ExceedUsageTime != null) {
            this.ExceedUsageTime = new Long(source.ExceedUsageTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AvailableConcurrency", this.AvailableConcurrency);
        this.setParamSimple(map, prefix + "ConcurrencyPeak", this.ConcurrencyPeak);
        this.setParamSimple(map, prefix + "ExceedUsageTime", this.ExceedUsageTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

