/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCorpResponse extends AbstractModel {

    /**
    * Corporate ID.

    */
    @SerializedName("CorpBizId")
    @Expose
    private String CorpBizId;

    /**
    * Application quota.
    */
    @SerializedName("RobotQuota")
    @Expose
    private Long RobotQuota;

    /**
    * Full name of the corporate.

    */
    @SerializedName("FullName")
    @Expose
    private String FullName;

    /**
    * Whether to try out.
    */
    @SerializedName("IsTrial")
    @Expose
    private Boolean IsTrial;

    /**
    * Whether the trial has expired.
    */
    @SerializedName("IsTrialExpired")
    @Expose
    private Boolean IsTrialExpired;

    /**
    * Quantity of available applications.
    */
    @SerializedName("AvailableAppQuota")
    @Expose
    private Long AvailableAppQuota;

    /**
    * Whether custom model configuration is supported.
    */
    @SerializedName("IsSupportCustomModel")
    @Expose
    private Boolean IsSupportCustomModel;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Corporate ID.
 
     * @return CorpBizId Corporate ID.

     */
    public String getCorpBizId() {
        return this.CorpBizId;
    }

    /**
     * Set Corporate ID.

     * @param CorpBizId Corporate ID.

     */
    public void setCorpBizId(String CorpBizId) {
        this.CorpBizId = CorpBizId;
    }

    /**
     * Get Application quota. 
     * @return RobotQuota Application quota.
     */
    public Long getRobotQuota() {
        return this.RobotQuota;
    }

    /**
     * Set Application quota.
     * @param RobotQuota Application quota.
     */
    public void setRobotQuota(Long RobotQuota) {
        this.RobotQuota = RobotQuota;
    }

    /**
     * Get Full name of the corporate.
 
     * @return FullName Full name of the corporate.

     */
    public String getFullName() {
        return this.FullName;
    }

    /**
     * Set Full name of the corporate.

     * @param FullName Full name of the corporate.

     */
    public void setFullName(String FullName) {
        this.FullName = FullName;
    }

    /**
     * Get Whether to try out. 
     * @return IsTrial Whether to try out.
     */
    public Boolean getIsTrial() {
        return this.IsTrial;
    }

    /**
     * Set Whether to try out.
     * @param IsTrial Whether to try out.
     */
    public void setIsTrial(Boolean IsTrial) {
        this.IsTrial = IsTrial;
    }

    /**
     * Get Whether the trial has expired. 
     * @return IsTrialExpired Whether the trial has expired.
     */
    public Boolean getIsTrialExpired() {
        return this.IsTrialExpired;
    }

    /**
     * Set Whether the trial has expired.
     * @param IsTrialExpired Whether the trial has expired.
     */
    public void setIsTrialExpired(Boolean IsTrialExpired) {
        this.IsTrialExpired = IsTrialExpired;
    }

    /**
     * Get Quantity of available applications. 
     * @return AvailableAppQuota Quantity of available applications.
     */
    public Long getAvailableAppQuota() {
        return this.AvailableAppQuota;
    }

    /**
     * Set Quantity of available applications.
     * @param AvailableAppQuota Quantity of available applications.
     */
    public void setAvailableAppQuota(Long AvailableAppQuota) {
        this.AvailableAppQuota = AvailableAppQuota;
    }

    /**
     * Get Whether custom model configuration is supported. 
     * @return IsSupportCustomModel Whether custom model configuration is supported.
     */
    public Boolean getIsSupportCustomModel() {
        return this.IsSupportCustomModel;
    }

    /**
     * Set Whether custom model configuration is supported.
     * @param IsSupportCustomModel Whether custom model configuration is supported.
     */
    public void setIsSupportCustomModel(Boolean IsSupportCustomModel) {
        this.IsSupportCustomModel = IsSupportCustomModel;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCorpResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCorpResponse(DescribeCorpResponse source) {
        if (source.CorpBizId != null) {
            this.CorpBizId = new String(source.CorpBizId);
        }
        if (source.RobotQuota != null) {
            this.RobotQuota = new Long(source.RobotQuota);
        }
        if (source.FullName != null) {
            this.FullName = new String(source.FullName);
        }
        if (source.IsTrial != null) {
            this.IsTrial = new Boolean(source.IsTrial);
        }
        if (source.IsTrialExpired != null) {
            this.IsTrialExpired = new Boolean(source.IsTrialExpired);
        }
        if (source.AvailableAppQuota != null) {
            this.AvailableAppQuota = new Long(source.AvailableAppQuota);
        }
        if (source.IsSupportCustomModel != null) {
            this.IsSupportCustomModel = new Boolean(source.IsSupportCustomModel);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CorpBizId", this.CorpBizId);
        this.setParamSimple(map, prefix + "RobotQuota", this.RobotQuota);
        this.setParamSimple(map, prefix + "FullName", this.FullName);
        this.setParamSimple(map, prefix + "IsTrial", this.IsTrial);
        this.setParamSimple(map, prefix + "IsTrialExpired", this.IsTrialExpired);
        this.setParamSimple(map, prefix + "AvailableAppQuota", this.AvailableAppQuota);
        this.setParamSimple(map, prefix + "IsSupportCustomModel", this.IsSupportCustomModel);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

