/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeReleaseInfoResponse extends AbstractModel {

    /**
    * The last release time.
    */
    @SerializedName("LastTime")
    @Expose
    private String LastTime;

    /**
    * Release status: 1: pending release; 2: releasing; 3: release successful; 4: release failed; 5: under review; 6: review successful; 7: review failed; 8: release successful, callback processing; 9: release paused; 10: appeal under review; 11: appeal approved; 12: appeal rejected.
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Whether it has been edited. When it is true, it means it can be released.
    */
    @SerializedName("IsUpdated")
    @Expose
    private Boolean IsUpdated;

    /**
    * Reason for failure.

    */
    @SerializedName("Msg")
    @Expose
    private String Msg;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get The last release time. 
     * @return LastTime The last release time.
     */
    public String getLastTime() {
        return this.LastTime;
    }

    /**
     * Set The last release time.
     * @param LastTime The last release time.
     */
    public void setLastTime(String LastTime) {
        this.LastTime = LastTime;
    }

    /**
     * Get Release status: 1: pending release; 2: releasing; 3: release successful; 4: release failed; 5: under review; 6: review successful; 7: review failed; 8: release successful, callback processing; 9: release paused; 10: appeal under review; 11: appeal approved; 12: appeal rejected. 
     * @return Status Release status: 1: pending release; 2: releasing; 3: release successful; 4: release failed; 5: under review; 6: review successful; 7: review failed; 8: release successful, callback processing; 9: release paused; 10: appeal under review; 11: appeal approved; 12: appeal rejected.
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Release status: 1: pending release; 2: releasing; 3: release successful; 4: release failed; 5: under review; 6: review successful; 7: review failed; 8: release successful, callback processing; 9: release paused; 10: appeal under review; 11: appeal approved; 12: appeal rejected.
     * @param Status Release status: 1: pending release; 2: releasing; 3: release successful; 4: release failed; 5: under review; 6: review successful; 7: review failed; 8: release successful, callback processing; 9: release paused; 10: appeal under review; 11: appeal approved; 12: appeal rejected.
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Whether it has been edited. When it is true, it means it can be released. 
     * @return IsUpdated Whether it has been edited. When it is true, it means it can be released.
     */
    public Boolean getIsUpdated() {
        return this.IsUpdated;
    }

    /**
     * Set Whether it has been edited. When it is true, it means it can be released.
     * @param IsUpdated Whether it has been edited. When it is true, it means it can be released.
     */
    public void setIsUpdated(Boolean IsUpdated) {
        this.IsUpdated = IsUpdated;
    }

    /**
     * Get Reason for failure.
 
     * @return Msg Reason for failure.

     */
    public String getMsg() {
        return this.Msg;
    }

    /**
     * Set Reason for failure.

     * @param Msg Reason for failure.

     */
    public void setMsg(String Msg) {
        this.Msg = Msg;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeReleaseInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeReleaseInfoResponse(DescribeReleaseInfoResponse source) {
        if (source.LastTime != null) {
            this.LastTime = new String(source.LastTime);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.IsUpdated != null) {
            this.IsUpdated = new Boolean(source.IsUpdated);
        }
        if (source.Msg != null) {
            this.Msg = new String(source.Msg);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "LastTime", this.LastTime);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "IsUpdated", this.IsUpdated);
        this.setParamSimple(map, prefix + "Msg", this.Msg);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

