/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeStorageCredentialResponse extends AbstractModel {

    /**
    * Key information.
    */
    @SerializedName("Credentials")
    @Expose
    private Credentials Credentials;

    /**
    * Expiration time.
    */
    @SerializedName("ExpiredTime")
    @Expose
    private Long ExpiredTime;

    /**
    * Start time.
    */
    @SerializedName("StartTime")
    @Expose
    private Long StartTime;

    /**
    * Cloud object storage bucket.
    */
    @SerializedName("Bucket")
    @Expose
    private String Bucket;

    /**
    * COS availability zone.
    */
    @SerializedName("Region")
    @Expose
    private String Region;

    /**
    * Cloud file storage directory.
    */
    @SerializedName("FilePath")
    @Expose
    private String FilePath;

    /**
    * Storage type.
    */
    @SerializedName("Type")
    @Expose
    private String Type;

    /**
    * Primary account.
    */
    @SerializedName("CorpUin")
    @Expose
    private String CorpUin;

    /**
    * Image storage directory.
    */
    @SerializedName("ImagePath")
    @Expose
    private String ImagePath;

    /**
    * Upload storage path to a specific file.
    */
    @SerializedName("UploadPath")
    @Expose
    private String UploadPath;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Key information. 
     * @return Credentials Key information.
     */
    public Credentials getCredentials() {
        return this.Credentials;
    }

    /**
     * Set Key information.
     * @param Credentials Key information.
     */
    public void setCredentials(Credentials Credentials) {
        this.Credentials = Credentials;
    }

    /**
     * Get Expiration time. 
     * @return ExpiredTime Expiration time.
     */
    public Long getExpiredTime() {
        return this.ExpiredTime;
    }

    /**
     * Set Expiration time.
     * @param ExpiredTime Expiration time.
     */
    public void setExpiredTime(Long ExpiredTime) {
        this.ExpiredTime = ExpiredTime;
    }

    /**
     * Get Start time. 
     * @return StartTime Start time.
     */
    public Long getStartTime() {
        return this.StartTime;
    }

    /**
     * Set Start time.
     * @param StartTime Start time.
     */
    public void setStartTime(Long StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get Cloud object storage bucket. 
     * @return Bucket Cloud object storage bucket.
     */
    public String getBucket() {
        return this.Bucket;
    }

    /**
     * Set Cloud object storage bucket.
     * @param Bucket Cloud object storage bucket.
     */
    public void setBucket(String Bucket) {
        this.Bucket = Bucket;
    }

    /**
     * Get COS availability zone. 
     * @return Region COS availability zone.
     */
    public String getRegion() {
        return this.Region;
    }

    /**
     * Set COS availability zone.
     * @param Region COS availability zone.
     */
    public void setRegion(String Region) {
        this.Region = Region;
    }

    /**
     * Get Cloud file storage directory. 
     * @return FilePath Cloud file storage directory.
     */
    public String getFilePath() {
        return this.FilePath;
    }

    /**
     * Set Cloud file storage directory.
     * @param FilePath Cloud file storage directory.
     */
    public void setFilePath(String FilePath) {
        this.FilePath = FilePath;
    }

    /**
     * Get Storage type. 
     * @return Type Storage type.
     */
    public String getType() {
        return this.Type;
    }

    /**
     * Set Storage type.
     * @param Type Storage type.
     */
    public void setType(String Type) {
        this.Type = Type;
    }

    /**
     * Get Primary account. 
     * @return CorpUin Primary account.
     */
    public String getCorpUin() {
        return this.CorpUin;
    }

    /**
     * Set Primary account.
     * @param CorpUin Primary account.
     */
    public void setCorpUin(String CorpUin) {
        this.CorpUin = CorpUin;
    }

    /**
     * Get Image storage directory. 
     * @return ImagePath Image storage directory.
     */
    public String getImagePath() {
        return this.ImagePath;
    }

    /**
     * Set Image storage directory.
     * @param ImagePath Image storage directory.
     */
    public void setImagePath(String ImagePath) {
        this.ImagePath = ImagePath;
    }

    /**
     * Get Upload storage path to a specific file. 
     * @return UploadPath Upload storage path to a specific file.
     */
    public String getUploadPath() {
        return this.UploadPath;
    }

    /**
     * Set Upload storage path to a specific file.
     * @param UploadPath Upload storage path to a specific file.
     */
    public void setUploadPath(String UploadPath) {
        this.UploadPath = UploadPath;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeStorageCredentialResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeStorageCredentialResponse(DescribeStorageCredentialResponse source) {
        if (source.Credentials != null) {
            this.Credentials = new Credentials(source.Credentials);
        }
        if (source.ExpiredTime != null) {
            this.ExpiredTime = new Long(source.ExpiredTime);
        }
        if (source.StartTime != null) {
            this.StartTime = new Long(source.StartTime);
        }
        if (source.Bucket != null) {
            this.Bucket = new String(source.Bucket);
        }
        if (source.Region != null) {
            this.Region = new String(source.Region);
        }
        if (source.FilePath != null) {
            this.FilePath = new String(source.FilePath);
        }
        if (source.Type != null) {
            this.Type = new String(source.Type);
        }
        if (source.CorpUin != null) {
            this.CorpUin = new String(source.CorpUin);
        }
        if (source.ImagePath != null) {
            this.ImagePath = new String(source.ImagePath);
        }
        if (source.UploadPath != null) {
            this.UploadPath = new String(source.UploadPath);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "Credentials.", this.Credentials);
        this.setParamSimple(map, prefix + "ExpiredTime", this.ExpiredTime);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "Bucket", this.Bucket);
        this.setParamSimple(map, prefix + "Region", this.Region);
        this.setParamSimple(map, prefix + "FilePath", this.FilePath);
        this.setParamSimple(map, prefix + "Type", this.Type);
        this.setParamSimple(map, prefix + "CorpUin", this.CorpUin);
        this.setParamSimple(map, prefix + "ImagePath", this.ImagePath);
        this.setParamSimple(map, prefix + "UploadPath", this.UploadPath);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

