/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTokenUsageGraphResponse extends AbstractModel {

    /**
    * Total amount of token consumption.
    */
    @SerializedName("Total")
    @Expose
    private Stat [] Total;

    /**
    * Input token consumption.
    */
    @SerializedName("Input")
    @Expose
    private Stat [] Input;

    /**
    * Output token consumption.
    */
    @SerializedName("Output")
    @Expose
    private Stat [] Output;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total amount of token consumption. 
     * @return Total Total amount of token consumption.
     */
    public Stat [] getTotal() {
        return this.Total;
    }

    /**
     * Set Total amount of token consumption.
     * @param Total Total amount of token consumption.
     */
    public void setTotal(Stat [] Total) {
        this.Total = Total;
    }

    /**
     * Get Input token consumption. 
     * @return Input Input token consumption.
     */
    public Stat [] getInput() {
        return this.Input;
    }

    /**
     * Set Input token consumption.
     * @param Input Input token consumption.
     */
    public void setInput(Stat [] Input) {
        this.Input = Input;
    }

    /**
     * Get Output token consumption. 
     * @return Output Output token consumption.
     */
    public Stat [] getOutput() {
        return this.Output;
    }

    /**
     * Set Output token consumption.
     * @param Output Output token consumption.
     */
    public void setOutput(Stat [] Output) {
        this.Output = Output;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTokenUsageGraphResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTokenUsageGraphResponse(DescribeTokenUsageGraphResponse source) {
        if (source.Total != null) {
            this.Total = new Stat[source.Total.length];
            for (int i = 0; i < source.Total.length; i++) {
                this.Total[i] = new Stat(source.Total[i]);
            }
        }
        if (source.Input != null) {
            this.Input = new Stat[source.Input.length];
            for (int i = 0; i < source.Input.length; i++) {
                this.Input[i] = new Stat(source.Input[i]);
            }
        }
        if (source.Output != null) {
            this.Output = new Stat[source.Output.length];
            for (int i = 0; i < source.Output.length; i++) {
                this.Output[i] = new Stat(source.Output[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Total.", this.Total);
        this.setParamArrayObj(map, prefix + "Input.", this.Input);
        this.setParamArrayObj(map, prefix + "Output.", this.Output);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

