/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTokenUsageResponse extends AbstractModel {

    /**
    * Total token consumption.
    */
    @SerializedName("TotalTokenUsage")
    @Expose
    private Float TotalTokenUsage;

    /**
    * Input token consumption.
    */
    @SerializedName("InputTokenUsage")
    @Expose
    private Float InputTokenUsage;

    /**
    * Output token consumption.
    */
    @SerializedName("OutputTokenUsage")
    @Expose
    private Float OutputTokenUsage;

    /**
    * Number of API calls.
    */
    @SerializedName("ApiCallStats")
    @Expose
    private Long ApiCallStats;

    /**
    * Number of search service calls.
    */
    @SerializedName("SearchUsage")
    @Expose
    private Float SearchUsage;

    /**
    * Number of pages consumed by document parsing.
    */
    @SerializedName("PageUsage")
    @Expose
    private Long PageUsage;

    /**
    * Token consumption by splitting.
    */
    @SerializedName("SplitTokenUsage")
    @Expose
    private Float SplitTokenUsage;

    /**
    * Number of Rag retrievals.
    */
    @SerializedName("RagSearchUsage")
    @Expose
    private Float RagSearchUsage;

    /**
    * Number of online searches.
    */
    @SerializedName("InternetSearchUsage")
    @Expose
    private Float InternetSearchUsage;

    /**
    * 
    */
    @SerializedName("DosageTypeLimit")
    @Expose
    private Float DosageTypeLimit;

    /**
    * 
    */
    @SerializedName("DosageTypeCurr")
    @Expose
    private Float DosageTypeCurr;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total token consumption. 
     * @return TotalTokenUsage Total token consumption.
     */
    public Float getTotalTokenUsage() {
        return this.TotalTokenUsage;
    }

    /**
     * Set Total token consumption.
     * @param TotalTokenUsage Total token consumption.
     */
    public void setTotalTokenUsage(Float TotalTokenUsage) {
        this.TotalTokenUsage = TotalTokenUsage;
    }

    /**
     * Get Input token consumption. 
     * @return InputTokenUsage Input token consumption.
     */
    public Float getInputTokenUsage() {
        return this.InputTokenUsage;
    }

    /**
     * Set Input token consumption.
     * @param InputTokenUsage Input token consumption.
     */
    public void setInputTokenUsage(Float InputTokenUsage) {
        this.InputTokenUsage = InputTokenUsage;
    }

    /**
     * Get Output token consumption. 
     * @return OutputTokenUsage Output token consumption.
     */
    public Float getOutputTokenUsage() {
        return this.OutputTokenUsage;
    }

    /**
     * Set Output token consumption.
     * @param OutputTokenUsage Output token consumption.
     */
    public void setOutputTokenUsage(Float OutputTokenUsage) {
        this.OutputTokenUsage = OutputTokenUsage;
    }

    /**
     * Get Number of API calls. 
     * @return ApiCallStats Number of API calls.
     */
    public Long getApiCallStats() {
        return this.ApiCallStats;
    }

    /**
     * Set Number of API calls.
     * @param ApiCallStats Number of API calls.
     */
    public void setApiCallStats(Long ApiCallStats) {
        this.ApiCallStats = ApiCallStats;
    }

    /**
     * Get Number of search service calls. 
     * @return SearchUsage Number of search service calls.
     */
    public Float getSearchUsage() {
        return this.SearchUsage;
    }

    /**
     * Set Number of search service calls.
     * @param SearchUsage Number of search service calls.
     */
    public void setSearchUsage(Float SearchUsage) {
        this.SearchUsage = SearchUsage;
    }

    /**
     * Get Number of pages consumed by document parsing. 
     * @return PageUsage Number of pages consumed by document parsing.
     */
    public Long getPageUsage() {
        return this.PageUsage;
    }

    /**
     * Set Number of pages consumed by document parsing.
     * @param PageUsage Number of pages consumed by document parsing.
     */
    public void setPageUsage(Long PageUsage) {
        this.PageUsage = PageUsage;
    }

    /**
     * Get Token consumption by splitting. 
     * @return SplitTokenUsage Token consumption by splitting.
     */
    public Float getSplitTokenUsage() {
        return this.SplitTokenUsage;
    }

    /**
     * Set Token consumption by splitting.
     * @param SplitTokenUsage Token consumption by splitting.
     */
    public void setSplitTokenUsage(Float SplitTokenUsage) {
        this.SplitTokenUsage = SplitTokenUsage;
    }

    /**
     * Get Number of Rag retrievals. 
     * @return RagSearchUsage Number of Rag retrievals.
     */
    public Float getRagSearchUsage() {
        return this.RagSearchUsage;
    }

    /**
     * Set Number of Rag retrievals.
     * @param RagSearchUsage Number of Rag retrievals.
     */
    public void setRagSearchUsage(Float RagSearchUsage) {
        this.RagSearchUsage = RagSearchUsage;
    }

    /**
     * Get Number of online searches. 
     * @return InternetSearchUsage Number of online searches.
     */
    public Float getInternetSearchUsage() {
        return this.InternetSearchUsage;
    }

    /**
     * Set Number of online searches.
     * @param InternetSearchUsage Number of online searches.
     */
    public void setInternetSearchUsage(Float InternetSearchUsage) {
        this.InternetSearchUsage = InternetSearchUsage;
    }

    /**
     * Get  
     * @return DosageTypeLimit 
     */
    public Float getDosageTypeLimit() {
        return this.DosageTypeLimit;
    }

    /**
     * Set 
     * @param DosageTypeLimit 
     */
    public void setDosageTypeLimit(Float DosageTypeLimit) {
        this.DosageTypeLimit = DosageTypeLimit;
    }

    /**
     * Get  
     * @return DosageTypeCurr 
     */
    public Float getDosageTypeCurr() {
        return this.DosageTypeCurr;
    }

    /**
     * Set 
     * @param DosageTypeCurr 
     */
    public void setDosageTypeCurr(Float DosageTypeCurr) {
        this.DosageTypeCurr = DosageTypeCurr;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTokenUsageResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTokenUsageResponse(DescribeTokenUsageResponse source) {
        if (source.TotalTokenUsage != null) {
            this.TotalTokenUsage = new Float(source.TotalTokenUsage);
        }
        if (source.InputTokenUsage != null) {
            this.InputTokenUsage = new Float(source.InputTokenUsage);
        }
        if (source.OutputTokenUsage != null) {
            this.OutputTokenUsage = new Float(source.OutputTokenUsage);
        }
        if (source.ApiCallStats != null) {
            this.ApiCallStats = new Long(source.ApiCallStats);
        }
        if (source.SearchUsage != null) {
            this.SearchUsage = new Float(source.SearchUsage);
        }
        if (source.PageUsage != null) {
            this.PageUsage = new Long(source.PageUsage);
        }
        if (source.SplitTokenUsage != null) {
            this.SplitTokenUsage = new Float(source.SplitTokenUsage);
        }
        if (source.RagSearchUsage != null) {
            this.RagSearchUsage = new Float(source.RagSearchUsage);
        }
        if (source.InternetSearchUsage != null) {
            this.InternetSearchUsage = new Float(source.InternetSearchUsage);
        }
        if (source.DosageTypeLimit != null) {
            this.DosageTypeLimit = new Float(source.DosageTypeLimit);
        }
        if (source.DosageTypeCurr != null) {
            this.DosageTypeCurr = new Float(source.DosageTypeCurr);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalTokenUsage", this.TotalTokenUsage);
        this.setParamSimple(map, prefix + "InputTokenUsage", this.InputTokenUsage);
        this.setParamSimple(map, prefix + "OutputTokenUsage", this.OutputTokenUsage);
        this.setParamSimple(map, prefix + "ApiCallStats", this.ApiCallStats);
        this.setParamSimple(map, prefix + "SearchUsage", this.SearchUsage);
        this.setParamSimple(map, prefix + "PageUsage", this.PageUsage);
        this.setParamSimple(map, prefix + "SplitTokenUsage", this.SplitTokenUsage);
        this.setParamSimple(map, prefix + "RagSearchUsage", this.RagSearchUsage);
        this.setParamSimple(map, prefix + "InternetSearchUsage", this.InternetSearchUsage);
        this.setParamSimple(map, prefix + "DosageTypeLimit", this.DosageTypeLimit);
        this.setParamSimple(map, prefix + "DosageTypeCurr", this.DosageTypeCurr);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

