/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetAnswerTypeDataCountResponse extends AbstractModel {

    /**
    * Total number of messages.
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * Total number of direct responses by the large model.
    */
    @SerializedName("ModelReplyCount")
    @Expose
    private Long ModelReplyCount;

    /**
    * Total number of knowledge-based responses.
    */
    @SerializedName("KnowledgeCount")
    @Expose
    private Long KnowledgeCount;

    /**
    * Total number of task flow responses.
    */
    @SerializedName("TaskFlowCount")
    @Expose
    private Long TaskFlowCount;

    /**
    * Total number of search engine responses.
    */
    @SerializedName("SearchEngineCount")
    @Expose
    private Long SearchEngineCount;

    /**
    * Total number of image understanding responses.
    */
    @SerializedName("ImageUnderstandingCount")
    @Expose
    private Long ImageUnderstandingCount;

    /**
    * Total number of responses to rejected questions.
    */
    @SerializedName("RejectCount")
    @Expose
    private Long RejectCount;

    /**
    * Total number of sensitive responses.
    */
    @SerializedName("SensitiveCount")
    @Expose
    private Long SensitiveCount;

    /**
    * Total number of responses for concurrency exceeded.
    */
    @SerializedName("ConcurrentLimitCount")
    @Expose
    private Long ConcurrentLimitCount;

    /**
    * Total number of unknown question responses.
    */
    @SerializedName("UnknownIssuesCount")
    @Expose
    private Long UnknownIssuesCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of messages. 
     * @return Total Total number of messages.
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set Total number of messages.
     * @param Total Total number of messages.
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get Total number of direct responses by the large model. 
     * @return ModelReplyCount Total number of direct responses by the large model.
     */
    public Long getModelReplyCount() {
        return this.ModelReplyCount;
    }

    /**
     * Set Total number of direct responses by the large model.
     * @param ModelReplyCount Total number of direct responses by the large model.
     */
    public void setModelReplyCount(Long ModelReplyCount) {
        this.ModelReplyCount = ModelReplyCount;
    }

    /**
     * Get Total number of knowledge-based responses. 
     * @return KnowledgeCount Total number of knowledge-based responses.
     */
    public Long getKnowledgeCount() {
        return this.KnowledgeCount;
    }

    /**
     * Set Total number of knowledge-based responses.
     * @param KnowledgeCount Total number of knowledge-based responses.
     */
    public void setKnowledgeCount(Long KnowledgeCount) {
        this.KnowledgeCount = KnowledgeCount;
    }

    /**
     * Get Total number of task flow responses. 
     * @return TaskFlowCount Total number of task flow responses.
     */
    public Long getTaskFlowCount() {
        return this.TaskFlowCount;
    }

    /**
     * Set Total number of task flow responses.
     * @param TaskFlowCount Total number of task flow responses.
     */
    public void setTaskFlowCount(Long TaskFlowCount) {
        this.TaskFlowCount = TaskFlowCount;
    }

    /**
     * Get Total number of search engine responses. 
     * @return SearchEngineCount Total number of search engine responses.
     */
    public Long getSearchEngineCount() {
        return this.SearchEngineCount;
    }

    /**
     * Set Total number of search engine responses.
     * @param SearchEngineCount Total number of search engine responses.
     */
    public void setSearchEngineCount(Long SearchEngineCount) {
        this.SearchEngineCount = SearchEngineCount;
    }

    /**
     * Get Total number of image understanding responses. 
     * @return ImageUnderstandingCount Total number of image understanding responses.
     */
    public Long getImageUnderstandingCount() {
        return this.ImageUnderstandingCount;
    }

    /**
     * Set Total number of image understanding responses.
     * @param ImageUnderstandingCount Total number of image understanding responses.
     */
    public void setImageUnderstandingCount(Long ImageUnderstandingCount) {
        this.ImageUnderstandingCount = ImageUnderstandingCount;
    }

    /**
     * Get Total number of responses to rejected questions. 
     * @return RejectCount Total number of responses to rejected questions.
     */
    public Long getRejectCount() {
        return this.RejectCount;
    }

    /**
     * Set Total number of responses to rejected questions.
     * @param RejectCount Total number of responses to rejected questions.
     */
    public void setRejectCount(Long RejectCount) {
        this.RejectCount = RejectCount;
    }

    /**
     * Get Total number of sensitive responses. 
     * @return SensitiveCount Total number of sensitive responses.
     */
    public Long getSensitiveCount() {
        return this.SensitiveCount;
    }

    /**
     * Set Total number of sensitive responses.
     * @param SensitiveCount Total number of sensitive responses.
     */
    public void setSensitiveCount(Long SensitiveCount) {
        this.SensitiveCount = SensitiveCount;
    }

    /**
     * Get Total number of responses for concurrency exceeded. 
     * @return ConcurrentLimitCount Total number of responses for concurrency exceeded.
     */
    public Long getConcurrentLimitCount() {
        return this.ConcurrentLimitCount;
    }

    /**
     * Set Total number of responses for concurrency exceeded.
     * @param ConcurrentLimitCount Total number of responses for concurrency exceeded.
     */
    public void setConcurrentLimitCount(Long ConcurrentLimitCount) {
        this.ConcurrentLimitCount = ConcurrentLimitCount;
    }

    /**
     * Get Total number of unknown question responses. 
     * @return UnknownIssuesCount Total number of unknown question responses.
     */
    public Long getUnknownIssuesCount() {
        return this.UnknownIssuesCount;
    }

    /**
     * Set Total number of unknown question responses.
     * @param UnknownIssuesCount Total number of unknown question responses.
     */
    public void setUnknownIssuesCount(Long UnknownIssuesCount) {
        this.UnknownIssuesCount = UnknownIssuesCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetAnswerTypeDataCountResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetAnswerTypeDataCountResponse(GetAnswerTypeDataCountResponse source) {
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.ModelReplyCount != null) {
            this.ModelReplyCount = new Long(source.ModelReplyCount);
        }
        if (source.KnowledgeCount != null) {
            this.KnowledgeCount = new Long(source.KnowledgeCount);
        }
        if (source.TaskFlowCount != null) {
            this.TaskFlowCount = new Long(source.TaskFlowCount);
        }
        if (source.SearchEngineCount != null) {
            this.SearchEngineCount = new Long(source.SearchEngineCount);
        }
        if (source.ImageUnderstandingCount != null) {
            this.ImageUnderstandingCount = new Long(source.ImageUnderstandingCount);
        }
        if (source.RejectCount != null) {
            this.RejectCount = new Long(source.RejectCount);
        }
        if (source.SensitiveCount != null) {
            this.SensitiveCount = new Long(source.SensitiveCount);
        }
        if (source.ConcurrentLimitCount != null) {
            this.ConcurrentLimitCount = new Long(source.ConcurrentLimitCount);
        }
        if (source.UnknownIssuesCount != null) {
            this.UnknownIssuesCount = new Long(source.UnknownIssuesCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamSimple(map, prefix + "ModelReplyCount", this.ModelReplyCount);
        this.setParamSimple(map, prefix + "KnowledgeCount", this.KnowledgeCount);
        this.setParamSimple(map, prefix + "TaskFlowCount", this.TaskFlowCount);
        this.setParamSimple(map, prefix + "SearchEngineCount", this.SearchEngineCount);
        this.setParamSimple(map, prefix + "ImageUnderstandingCount", this.ImageUnderstandingCount);
        this.setParamSimple(map, prefix + "RejectCount", this.RejectCount);
        this.setParamSimple(map, prefix + "SensitiveCount", this.SensitiveCount);
        this.setParamSimple(map, prefix + "ConcurrentLimitCount", this.ConcurrentLimitCount);
        this.setParamSimple(map, prefix + "UnknownIssuesCount", this.UnknownIssuesCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

