/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetDocPreviewResponse extends AbstractModel {

    /**
    * Filename. The release end always uses this name.
    */
    @SerializedName("FileName")
    @Expose
    private String FileName;

    /**
    * File type.
    */
    @SerializedName("FileType")
    @Expose
    private String FileType;

    /**
    * COS path.

    */
    @SerializedName("CosUrl")
    @Expose
    private String CosUrl;

    /**
    * COS temporary url.

    */
    @SerializedName("Url")
    @Expose
    private String Url;

    /**
    * COS bucket.

    */
    @SerializedName("Bucket")
    @Expose
    private String Bucket;

    /**
    * It is the new name in the case of document renaming. It shall be used preferentially on the evaluation end.
    */
    @SerializedName("NewName")
    @Expose
    private String NewName;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Filename. The release end always uses this name. 
     * @return FileName Filename. The release end always uses this name.
     */
    public String getFileName() {
        return this.FileName;
    }

    /**
     * Set Filename. The release end always uses this name.
     * @param FileName Filename. The release end always uses this name.
     */
    public void setFileName(String FileName) {
        this.FileName = FileName;
    }

    /**
     * Get File type. 
     * @return FileType File type.
     */
    public String getFileType() {
        return this.FileType;
    }

    /**
     * Set File type.
     * @param FileType File type.
     */
    public void setFileType(String FileType) {
        this.FileType = FileType;
    }

    /**
     * Get COS path.
 
     * @return CosUrl COS path.

     */
    public String getCosUrl() {
        return this.CosUrl;
    }

    /**
     * Set COS path.

     * @param CosUrl COS path.

     */
    public void setCosUrl(String CosUrl) {
        this.CosUrl = CosUrl;
    }

    /**
     * Get COS temporary url.
 
     * @return Url COS temporary url.

     */
    public String getUrl() {
        return this.Url;
    }

    /**
     * Set COS temporary url.

     * @param Url COS temporary url.

     */
    public void setUrl(String Url) {
        this.Url = Url;
    }

    /**
     * Get COS bucket.
 
     * @return Bucket COS bucket.

     */
    public String getBucket() {
        return this.Bucket;
    }

    /**
     * Set COS bucket.

     * @param Bucket COS bucket.

     */
    public void setBucket(String Bucket) {
        this.Bucket = Bucket;
    }

    /**
     * Get It is the new name in the case of document renaming. It shall be used preferentially on the evaluation end. 
     * @return NewName It is the new name in the case of document renaming. It shall be used preferentially on the evaluation end.
     */
    public String getNewName() {
        return this.NewName;
    }

    /**
     * Set It is the new name in the case of document renaming. It shall be used preferentially on the evaluation end.
     * @param NewName It is the new name in the case of document renaming. It shall be used preferentially on the evaluation end.
     */
    public void setNewName(String NewName) {
        this.NewName = NewName;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetDocPreviewResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetDocPreviewResponse(GetDocPreviewResponse source) {
        if (source.FileName != null) {
            this.FileName = new String(source.FileName);
        }
        if (source.FileType != null) {
            this.FileType = new String(source.FileType);
        }
        if (source.CosUrl != null) {
            this.CosUrl = new String(source.CosUrl);
        }
        if (source.Url != null) {
            this.Url = new String(source.Url);
        }
        if (source.Bucket != null) {
            this.Bucket = new String(source.Bucket);
        }
        if (source.NewName != null) {
            this.NewName = new String(source.NewName);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "FileName", this.FileName);
        this.setParamSimple(map, prefix + "FileType", this.FileType);
        this.setParamSimple(map, prefix + "CosUrl", this.CosUrl);
        this.setParamSimple(map, prefix + "Url", this.Url);
        this.setParamSimple(map, prefix + "Bucket", this.Bucket);
        this.setParamSimple(map, prefix + "NewName", this.NewName);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

