/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetLikeDataCountResponse extends AbstractModel {

    /**
    * Number of messages that can be evaluated.
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * Number of comments.
    */
    @SerializedName("AppraisalTotal")
    @Expose
    private Long AppraisalTotal;

    /**
    * Participation rate.
    */
    @SerializedName("ParticipationRate")
    @Expose
    private Float ParticipationRate;

    /**
    * Number of likes.
    */
    @SerializedName("LikeTotal")
    @Expose
    private Long LikeTotal;

    /**
    * Like rate.
    */
    @SerializedName("LikeRate")
    @Expose
    private Float LikeRate;

    /**
    * Number of dislikes.
    */
    @SerializedName("DislikeTotal")
    @Expose
    private Long DislikeTotal;

    /**
    * Dislike rate.
    */
    @SerializedName("DislikeRate")
    @Expose
    private Float DislikeRate;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of messages that can be evaluated. 
     * @return Total Number of messages that can be evaluated.
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set Number of messages that can be evaluated.
     * @param Total Number of messages that can be evaluated.
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get Number of comments. 
     * @return AppraisalTotal Number of comments.
     */
    public Long getAppraisalTotal() {
        return this.AppraisalTotal;
    }

    /**
     * Set Number of comments.
     * @param AppraisalTotal Number of comments.
     */
    public void setAppraisalTotal(Long AppraisalTotal) {
        this.AppraisalTotal = AppraisalTotal;
    }

    /**
     * Get Participation rate. 
     * @return ParticipationRate Participation rate.
     */
    public Float getParticipationRate() {
        return this.ParticipationRate;
    }

    /**
     * Set Participation rate.
     * @param ParticipationRate Participation rate.
     */
    public void setParticipationRate(Float ParticipationRate) {
        this.ParticipationRate = ParticipationRate;
    }

    /**
     * Get Number of likes. 
     * @return LikeTotal Number of likes.
     */
    public Long getLikeTotal() {
        return this.LikeTotal;
    }

    /**
     * Set Number of likes.
     * @param LikeTotal Number of likes.
     */
    public void setLikeTotal(Long LikeTotal) {
        this.LikeTotal = LikeTotal;
    }

    /**
     * Get Like rate. 
     * @return LikeRate Like rate.
     */
    public Float getLikeRate() {
        return this.LikeRate;
    }

    /**
     * Set Like rate.
     * @param LikeRate Like rate.
     */
    public void setLikeRate(Float LikeRate) {
        this.LikeRate = LikeRate;
    }

    /**
     * Get Number of dislikes. 
     * @return DislikeTotal Number of dislikes.
     */
    public Long getDislikeTotal() {
        return this.DislikeTotal;
    }

    /**
     * Set Number of dislikes.
     * @param DislikeTotal Number of dislikes.
     */
    public void setDislikeTotal(Long DislikeTotal) {
        this.DislikeTotal = DislikeTotal;
    }

    /**
     * Get Dislike rate. 
     * @return DislikeRate Dislike rate.
     */
    public Float getDislikeRate() {
        return this.DislikeRate;
    }

    /**
     * Set Dislike rate.
     * @param DislikeRate Dislike rate.
     */
    public void setDislikeRate(Float DislikeRate) {
        this.DislikeRate = DislikeRate;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetLikeDataCountResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetLikeDataCountResponse(GetLikeDataCountResponse source) {
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.AppraisalTotal != null) {
            this.AppraisalTotal = new Long(source.AppraisalTotal);
        }
        if (source.ParticipationRate != null) {
            this.ParticipationRate = new Float(source.ParticipationRate);
        }
        if (source.LikeTotal != null) {
            this.LikeTotal = new Long(source.LikeTotal);
        }
        if (source.LikeRate != null) {
            this.LikeRate = new Float(source.LikeRate);
        }
        if (source.DislikeTotal != null) {
            this.DislikeTotal = new Long(source.DislikeTotal);
        }
        if (source.DislikeRate != null) {
            this.DislikeRate = new Float(source.DislikeRate);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamSimple(map, prefix + "AppraisalTotal", this.AppraisalTotal);
        this.setParamSimple(map, prefix + "ParticipationRate", this.ParticipationRate);
        this.setParamSimple(map, prefix + "LikeTotal", this.LikeTotal);
        this.setParamSimple(map, prefix + "LikeRate", this.LikeRate);
        this.setParamSimple(map, prefix + "DislikeTotal", this.DislikeTotal);
        this.setParamSimple(map, prefix + "DislikeRate", this.DislikeRate);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

