/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetMsgRecordResponse extends AbstractModel {

    /**
    * Session record.
    */
    @SerializedName("Records")
    @Expose
    private MsgRecord [] Records;

    /**
    * The time when session cleared associated context, in milliseconds.
    */
    @SerializedName("SessionDisassociatedTimestamp")
    @Expose
    private String SessionDisassociatedTimestamp;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Session record. 
     * @return Records Session record.
     */
    public MsgRecord [] getRecords() {
        return this.Records;
    }

    /**
     * Set Session record.
     * @param Records Session record.
     */
    public void setRecords(MsgRecord [] Records) {
        this.Records = Records;
    }

    /**
     * Get The time when session cleared associated context, in milliseconds. 
     * @return SessionDisassociatedTimestamp The time when session cleared associated context, in milliseconds.
     */
    public String getSessionDisassociatedTimestamp() {
        return this.SessionDisassociatedTimestamp;
    }

    /**
     * Set The time when session cleared associated context, in milliseconds.
     * @param SessionDisassociatedTimestamp The time when session cleared associated context, in milliseconds.
     */
    public void setSessionDisassociatedTimestamp(String SessionDisassociatedTimestamp) {
        this.SessionDisassociatedTimestamp = SessionDisassociatedTimestamp;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetMsgRecordResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetMsgRecordResponse(GetMsgRecordResponse source) {
        if (source.Records != null) {
            this.Records = new MsgRecord[source.Records.length];
            for (int i = 0; i < source.Records.length; i++) {
                this.Records[i] = new MsgRecord(source.Records[i]);
            }
        }
        if (source.SessionDisassociatedTimestamp != null) {
            this.SessionDisassociatedTimestamp = new String(source.SessionDisassociatedTimestamp);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Records.", this.Records);
        this.setParamSimple(map, prefix + "SessionDisassociatedTimestamp", this.SessionDisassociatedTimestamp);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

