/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetWsTokenResponse extends AbstractModel {

    /**
    * Token value (valid for 60 seconds, valid only once, multiple validations will report an error).
    */
    @SerializedName("Token")
    @Expose
    private String Token;

    /**
    * Balance. The balance is valid if it is greater than 0.
    */
    @SerializedName("Balance")
    @Expose
    private Float Balance;

    /**
    * The character limit for input in the chat window.
    */
    @SerializedName("InputLenLimit")
    @Expose
    private Long InputLenLimit;

    /**
    * Application mode: standard; agent; single_workflow.
    */
    @SerializedName("Pattern")
    @Expose
    private String Pattern;

    /**
    * SingleWorkflow.
    */
    @SerializedName("SingleWorkflow")
    @Expose
    private KnowledgeQaSingleWorkflow SingleWorkflow;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Token value (valid for 60 seconds, valid only once, multiple validations will report an error). 
     * @return Token Token value (valid for 60 seconds, valid only once, multiple validations will report an error).
     */
    public String getToken() {
        return this.Token;
    }

    /**
     * Set Token value (valid for 60 seconds, valid only once, multiple validations will report an error).
     * @param Token Token value (valid for 60 seconds, valid only once, multiple validations will report an error).
     */
    public void setToken(String Token) {
        this.Token = Token;
    }

    /**
     * Get Balance. The balance is valid if it is greater than 0. 
     * @return Balance Balance. The balance is valid if it is greater than 0.
     */
    public Float getBalance() {
        return this.Balance;
    }

    /**
     * Set Balance. The balance is valid if it is greater than 0.
     * @param Balance Balance. The balance is valid if it is greater than 0.
     */
    public void setBalance(Float Balance) {
        this.Balance = Balance;
    }

    /**
     * Get The character limit for input in the chat window. 
     * @return InputLenLimit The character limit for input in the chat window.
     */
    public Long getInputLenLimit() {
        return this.InputLenLimit;
    }

    /**
     * Set The character limit for input in the chat window.
     * @param InputLenLimit The character limit for input in the chat window.
     */
    public void setInputLenLimit(Long InputLenLimit) {
        this.InputLenLimit = InputLenLimit;
    }

    /**
     * Get Application mode: standard; agent; single_workflow. 
     * @return Pattern Application mode: standard; agent; single_workflow.
     */
    public String getPattern() {
        return this.Pattern;
    }

    /**
     * Set Application mode: standard; agent; single_workflow.
     * @param Pattern Application mode: standard; agent; single_workflow.
     */
    public void setPattern(String Pattern) {
        this.Pattern = Pattern;
    }

    /**
     * Get SingleWorkflow. 
     * @return SingleWorkflow SingleWorkflow.
     */
    public KnowledgeQaSingleWorkflow getSingleWorkflow() {
        return this.SingleWorkflow;
    }

    /**
     * Set SingleWorkflow.
     * @param SingleWorkflow SingleWorkflow.
     */
    public void setSingleWorkflow(KnowledgeQaSingleWorkflow SingleWorkflow) {
        this.SingleWorkflow = SingleWorkflow;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetWsTokenResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetWsTokenResponse(GetWsTokenResponse source) {
        if (source.Token != null) {
            this.Token = new String(source.Token);
        }
        if (source.Balance != null) {
            this.Balance = new Float(source.Balance);
        }
        if (source.InputLenLimit != null) {
            this.InputLenLimit = new Long(source.InputLenLimit);
        }
        if (source.Pattern != null) {
            this.Pattern = new String(source.Pattern);
        }
        if (source.SingleWorkflow != null) {
            this.SingleWorkflow = new KnowledgeQaSingleWorkflow(source.SingleWorkflow);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Token", this.Token);
        this.setParamSimple(map, prefix + "Balance", this.Balance);
        this.setParamSimple(map, prefix + "InputLenLimit", this.InputLenLimit);
        this.setParamSimple(map, prefix + "Pattern", this.Pattern);
        this.setParamObj(map, prefix + "SingleWorkflow.", this.SingleWorkflow);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

