/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ListQAResponse extends AbstractModel {

    /**
    * Q&A quantity.
    */
    @SerializedName("Total")
    @Expose
    private String Total;

    /**
    * Quantity of pending verification Q&As.
    */
    @SerializedName("WaitVerifyTotal")
    @Expose
    private String WaitVerifyTotal;

    /**
    * Quantity of not adopted Q&As.
    */
    @SerializedName("NotAcceptedTotal")
    @Expose
    private String NotAcceptedTotal;

    /**
    * Quantity of adopted Q&As.
    */
    @SerializedName("AcceptedTotal")
    @Expose
    private String AcceptedTotal;

    /**
    * Page number.
    */
    @SerializedName("PageNumber")
    @Expose
    private Long PageNumber;

    /**
    * Q&As details.
    */
    @SerializedName("List")
    @Expose
    private ListQaItem [] List;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Q&A quantity. 
     * @return Total Q&A quantity.
     */
    public String getTotal() {
        return this.Total;
    }

    /**
     * Set Q&A quantity.
     * @param Total Q&A quantity.
     */
    public void setTotal(String Total) {
        this.Total = Total;
    }

    /**
     * Get Quantity of pending verification Q&As. 
     * @return WaitVerifyTotal Quantity of pending verification Q&As.
     */
    public String getWaitVerifyTotal() {
        return this.WaitVerifyTotal;
    }

    /**
     * Set Quantity of pending verification Q&As.
     * @param WaitVerifyTotal Quantity of pending verification Q&As.
     */
    public void setWaitVerifyTotal(String WaitVerifyTotal) {
        this.WaitVerifyTotal = WaitVerifyTotal;
    }

    /**
     * Get Quantity of not adopted Q&As. 
     * @return NotAcceptedTotal Quantity of not adopted Q&As.
     */
    public String getNotAcceptedTotal() {
        return this.NotAcceptedTotal;
    }

    /**
     * Set Quantity of not adopted Q&As.
     * @param NotAcceptedTotal Quantity of not adopted Q&As.
     */
    public void setNotAcceptedTotal(String NotAcceptedTotal) {
        this.NotAcceptedTotal = NotAcceptedTotal;
    }

    /**
     * Get Quantity of adopted Q&As. 
     * @return AcceptedTotal Quantity of adopted Q&As.
     */
    public String getAcceptedTotal() {
        return this.AcceptedTotal;
    }

    /**
     * Set Quantity of adopted Q&As.
     * @param AcceptedTotal Quantity of adopted Q&As.
     */
    public void setAcceptedTotal(String AcceptedTotal) {
        this.AcceptedTotal = AcceptedTotal;
    }

    /**
     * Get Page number. 
     * @return PageNumber Page number.
     */
    public Long getPageNumber() {
        return this.PageNumber;
    }

    /**
     * Set Page number.
     * @param PageNumber Page number.
     */
    public void setPageNumber(Long PageNumber) {
        this.PageNumber = PageNumber;
    }

    /**
     * Get Q&As details. 
     * @return List Q&As details.
     */
    public ListQaItem [] getList() {
        return this.List;
    }

    /**
     * Set Q&As details.
     * @param List Q&As details.
     */
    public void setList(ListQaItem [] List) {
        this.List = List;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ListQAResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ListQAResponse(ListQAResponse source) {
        if (source.Total != null) {
            this.Total = new String(source.Total);
        }
        if (source.WaitVerifyTotal != null) {
            this.WaitVerifyTotal = new String(source.WaitVerifyTotal);
        }
        if (source.NotAcceptedTotal != null) {
            this.NotAcceptedTotal = new String(source.NotAcceptedTotal);
        }
        if (source.AcceptedTotal != null) {
            this.AcceptedTotal = new String(source.AcceptedTotal);
        }
        if (source.PageNumber != null) {
            this.PageNumber = new Long(source.PageNumber);
        }
        if (source.List != null) {
            this.List = new ListQaItem[source.List.length];
            for (int i = 0; i < source.List.length; i++) {
                this.List[i] = new ListQaItem(source.List[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamSimple(map, prefix + "WaitVerifyTotal", this.WaitVerifyTotal);
        this.setParamSimple(map, prefix + "NotAcceptedTotal", this.NotAcceptedTotal);
        this.setParamSimple(map, prefix + "AcceptedTotal", this.AcceptedTotal);
        this.setParamSimple(map, prefix + "PageNumber", this.PageNumber);
        this.setParamArrayObj(map, prefix + "List.", this.List);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

