/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class UploadAttributeLabelResponse extends AbstractModel {

    /**
    * Import error.
    */
    @SerializedName("ErrorMsg")
    @Expose
    private String ErrorMsg;

    /**
    * Error link.
    */
    @SerializedName("ErrorLink")
    @Expose
    private String ErrorLink;

    /**
    * Error link text.
    */
    @SerializedName("ErrorLinkText")
    @Expose
    private String ErrorLinkText;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Import error. 
     * @return ErrorMsg Import error.
     */
    public String getErrorMsg() {
        return this.ErrorMsg;
    }

    /**
     * Set Import error.
     * @param ErrorMsg Import error.
     */
    public void setErrorMsg(String ErrorMsg) {
        this.ErrorMsg = ErrorMsg;
    }

    /**
     * Get Error link. 
     * @return ErrorLink Error link.
     */
    public String getErrorLink() {
        return this.ErrorLink;
    }

    /**
     * Set Error link.
     * @param ErrorLink Error link.
     */
    public void setErrorLink(String ErrorLink) {
        this.ErrorLink = ErrorLink;
    }

    /**
     * Get Error link text. 
     * @return ErrorLinkText Error link text.
     */
    public String getErrorLinkText() {
        return this.ErrorLinkText;
    }

    /**
     * Set Error link text.
     * @param ErrorLinkText Error link text.
     */
    public void setErrorLinkText(String ErrorLinkText) {
        this.ErrorLinkText = ErrorLinkText;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public UploadAttributeLabelResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public UploadAttributeLabelResponse(UploadAttributeLabelResponse source) {
        if (source.ErrorMsg != null) {
            this.ErrorMsg = new String(source.ErrorMsg);
        }
        if (source.ErrorLink != null) {
            this.ErrorLink = new String(source.ErrorLink);
        }
        if (source.ErrorLinkText != null) {
            this.ErrorLinkText = new String(source.ErrorLinkText);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ErrorMsg", this.ErrorMsg);
        this.setParamSimple(map, prefix + "ErrorLink", this.ErrorLink);
        this.setParamSimple(map, prefix + "ErrorLinkText", this.ErrorLinkText);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

