/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lkeap.v20240522.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetSplitDocumentResultResponse extends AbstractModel {

    /**
    * Task status:
-Success: execution completed.
-Processing: executing.
-Pause: paused.
-Failed: execution failed.
-WaitExecute: pending execution.
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * Temporary download URL for the splitting result. The file is a zip compressed package, and the URL is valid for 30 minutes. The compressed package contains the following folders: \*.md, \*.jsonl, \*mllm.json, images.
>**jsonl** structure description:.
- page_content: Used to generate an embedding library for retrieval purposes. The images in this field will be replaced with placeholders.
- org_data: The minimum semantic integrity block corresponding to page_content, used for Q&A model processing.
- big_data: The maximum semantic integrity block corresponding to page_content, also used for Q&A model processing.
    */
    @SerializedName("DocumentRecognizeResultUrl")
    @Expose
    private String DocumentRecognizeResultUrl;

    /**
    * Page number where document splitting fails.
    */
    @SerializedName("FailedPages")
    @Expose
    private SplitDocumentFailedPage [] FailedPages;

    /**
    * Amount of the document split task.
    */
    @SerializedName("Usage")
    @Expose
    private DocumentUsage Usage;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task status:
-Success: execution completed.
-Processing: executing.
-Pause: paused.
-Failed: execution failed.
-WaitExecute: pending execution. 
     * @return Status Task status:
-Success: execution completed.
-Processing: executing.
-Pause: paused.
-Failed: execution failed.
-WaitExecute: pending execution.
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set Task status:
-Success: execution completed.
-Processing: executing.
-Pause: paused.
-Failed: execution failed.
-WaitExecute: pending execution.
     * @param Status Task status:
-Success: execution completed.
-Processing: executing.
-Pause: paused.
-Failed: execution failed.
-WaitExecute: pending execution.
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get Temporary download URL for the splitting result. The file is a zip compressed package, and the URL is valid for 30 minutes. The compressed package contains the following folders: \*.md, \*.jsonl, \*mllm.json, images.
>**jsonl** structure description:.
- page_content: Used to generate an embedding library for retrieval purposes. The images in this field will be replaced with placeholders.
- org_data: The minimum semantic integrity block corresponding to page_content, used for Q&A model processing.
- big_data: The maximum semantic integrity block corresponding to page_content, also used for Q&A model processing. 
     * @return DocumentRecognizeResultUrl Temporary download URL for the splitting result. The file is a zip compressed package, and the URL is valid for 30 minutes. The compressed package contains the following folders: \*.md, \*.jsonl, \*mllm.json, images.
>**jsonl** structure description:.
- page_content: Used to generate an embedding library for retrieval purposes. The images in this field will be replaced with placeholders.
- org_data: The minimum semantic integrity block corresponding to page_content, used for Q&A model processing.
- big_data: The maximum semantic integrity block corresponding to page_content, also used for Q&A model processing.
     */
    public String getDocumentRecognizeResultUrl() {
        return this.DocumentRecognizeResultUrl;
    }

    /**
     * Set Temporary download URL for the splitting result. The file is a zip compressed package, and the URL is valid for 30 minutes. The compressed package contains the following folders: \*.md, \*.jsonl, \*mllm.json, images.
>**jsonl** structure description:.
- page_content: Used to generate an embedding library for retrieval purposes. The images in this field will be replaced with placeholders.
- org_data: The minimum semantic integrity block corresponding to page_content, used for Q&A model processing.
- big_data: The maximum semantic integrity block corresponding to page_content, also used for Q&A model processing.
     * @param DocumentRecognizeResultUrl Temporary download URL for the splitting result. The file is a zip compressed package, and the URL is valid for 30 minutes. The compressed package contains the following folders: \*.md, \*.jsonl, \*mllm.json, images.
>**jsonl** structure description:.
- page_content: Used to generate an embedding library for retrieval purposes. The images in this field will be replaced with placeholders.
- org_data: The minimum semantic integrity block corresponding to page_content, used for Q&A model processing.
- big_data: The maximum semantic integrity block corresponding to page_content, also used for Q&A model processing.
     */
    public void setDocumentRecognizeResultUrl(String DocumentRecognizeResultUrl) {
        this.DocumentRecognizeResultUrl = DocumentRecognizeResultUrl;
    }

    /**
     * Get Page number where document splitting fails. 
     * @return FailedPages Page number where document splitting fails.
     * @deprecated
     */
    @Deprecated
    public SplitDocumentFailedPage [] getFailedPages() {
        return this.FailedPages;
    }

    /**
     * Set Page number where document splitting fails.
     * @param FailedPages Page number where document splitting fails.
     * @deprecated
     */
    @Deprecated
    public void setFailedPages(SplitDocumentFailedPage [] FailedPages) {
        this.FailedPages = FailedPages;
    }

    /**
     * Get Amount of the document split task. 
     * @return Usage Amount of the document split task.
     */
    public DocumentUsage getUsage() {
        return this.Usage;
    }

    /**
     * Set Amount of the document split task.
     * @param Usage Amount of the document split task.
     */
    public void setUsage(DocumentUsage Usage) {
        this.Usage = Usage;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetSplitDocumentResultResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetSplitDocumentResultResponse(GetSplitDocumentResultResponse source) {
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.DocumentRecognizeResultUrl != null) {
            this.DocumentRecognizeResultUrl = new String(source.DocumentRecognizeResultUrl);
        }
        if (source.FailedPages != null) {
            this.FailedPages = new SplitDocumentFailedPage[source.FailedPages.length];
            for (int i = 0; i < source.FailedPages.length; i++) {
                this.FailedPages[i] = new SplitDocumentFailedPage(source.FailedPages[i]);
            }
        }
        if (source.Usage != null) {
            this.Usage = new DocumentUsage(source.Usage);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "DocumentRecognizeResultUrl", this.DocumentRecognizeResultUrl);
        this.setParamArrayObj(map, prefix + "FailedPages.", this.FailedPages);
        this.setParamObj(map, prefix + "Usage.", this.Usage);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

