/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mongodb.v20190725.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDBInstanceNamespaceResponse extends AbstractModel {

    /**
    * List of databases of the queried instance. If no database is specified for querying with DbName, a list of databases of only the queried instance is returned instead of the information indicated by Collections.
    */
    @SerializedName("Databases")
    @Expose
    private String [] Databases;

    /**
    * Queried collection information. If DbName is specified, a list of collections of only this database is returned.
    */
    @SerializedName("Collections")
    @Expose
    private String [] Collections;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of databases of the queried instance. If no database is specified for querying with DbName, a list of databases of only the queried instance is returned instead of the information indicated by Collections. 
     * @return Databases List of databases of the queried instance. If no database is specified for querying with DbName, a list of databases of only the queried instance is returned instead of the information indicated by Collections.
     */
    public String [] getDatabases() {
        return this.Databases;
    }

    /**
     * Set List of databases of the queried instance. If no database is specified for querying with DbName, a list of databases of only the queried instance is returned instead of the information indicated by Collections.
     * @param Databases List of databases of the queried instance. If no database is specified for querying with DbName, a list of databases of only the queried instance is returned instead of the information indicated by Collections.
     */
    public void setDatabases(String [] Databases) {
        this.Databases = Databases;
    }

    /**
     * Get Queried collection information. If DbName is specified, a list of collections of only this database is returned. 
     * @return Collections Queried collection information. If DbName is specified, a list of collections of only this database is returned.
     */
    public String [] getCollections() {
        return this.Collections;
    }

    /**
     * Set Queried collection information. If DbName is specified, a list of collections of only this database is returned.
     * @param Collections Queried collection information. If DbName is specified, a list of collections of only this database is returned.
     */
    public void setCollections(String [] Collections) {
        this.Collections = Collections;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDBInstanceNamespaceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDBInstanceNamespaceResponse(DescribeDBInstanceNamespaceResponse source) {
        if (source.Databases != null) {
            this.Databases = new String[source.Databases.length];
            for (int i = 0; i < source.Databases.length; i++) {
                this.Databases[i] = new String(source.Databases[i]);
            }
        }
        if (source.Collections != null) {
            this.Collections = new String[source.Collections.length];
            for (int i = 0; i < source.Collections.length; i++) {
                this.Collections[i] = new String(source.Collections[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "Databases.", this.Databases);
        this.setParamArraySimple(map, prefix + "Collections.", this.Collections);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

