/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mongodb.v20190725.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInstanceParamsResponse extends AbstractModel {

    /**
    * Collection of parameters whose values are of the Enum type.
    */
    @SerializedName("InstanceEnumParam")
    @Expose
    private InstanceEnumParam [] InstanceEnumParam;

    /**
    * Collection of parameters whose values are of the Integer type.
    */
    @SerializedName("InstanceIntegerParam")
    @Expose
    private InstanceIntegerParam [] InstanceIntegerParam;

    /**
    * Collection of parameters whose values are of the Text type.
    */
    @SerializedName("InstanceTextParam")
    @Expose
    private InstanceTextParam [] InstanceTextParam;

    /**
    * Collection of parameters whose values are of different types.
    */
    @SerializedName("InstanceMultiParam")
    @Expose
    private InstanceMultiParam [] InstanceMultiParam;

    /**
    * Number of modifiable parameters supported by the current instance.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Collection of parameters whose values are of the Enum type. 
     * @return InstanceEnumParam Collection of parameters whose values are of the Enum type.
     */
    public InstanceEnumParam [] getInstanceEnumParam() {
        return this.InstanceEnumParam;
    }

    /**
     * Set Collection of parameters whose values are of the Enum type.
     * @param InstanceEnumParam Collection of parameters whose values are of the Enum type.
     */
    public void setInstanceEnumParam(InstanceEnumParam [] InstanceEnumParam) {
        this.InstanceEnumParam = InstanceEnumParam;
    }

    /**
     * Get Collection of parameters whose values are of the Integer type. 
     * @return InstanceIntegerParam Collection of parameters whose values are of the Integer type.
     */
    public InstanceIntegerParam [] getInstanceIntegerParam() {
        return this.InstanceIntegerParam;
    }

    /**
     * Set Collection of parameters whose values are of the Integer type.
     * @param InstanceIntegerParam Collection of parameters whose values are of the Integer type.
     */
    public void setInstanceIntegerParam(InstanceIntegerParam [] InstanceIntegerParam) {
        this.InstanceIntegerParam = InstanceIntegerParam;
    }

    /**
     * Get Collection of parameters whose values are of the Text type. 
     * @return InstanceTextParam Collection of parameters whose values are of the Text type.
     */
    public InstanceTextParam [] getInstanceTextParam() {
        return this.InstanceTextParam;
    }

    /**
     * Set Collection of parameters whose values are of the Text type.
     * @param InstanceTextParam Collection of parameters whose values are of the Text type.
     */
    public void setInstanceTextParam(InstanceTextParam [] InstanceTextParam) {
        this.InstanceTextParam = InstanceTextParam;
    }

    /**
     * Get Collection of parameters whose values are of different types. 
     * @return InstanceMultiParam Collection of parameters whose values are of different types.
     */
    public InstanceMultiParam [] getInstanceMultiParam() {
        return this.InstanceMultiParam;
    }

    /**
     * Set Collection of parameters whose values are of different types.
     * @param InstanceMultiParam Collection of parameters whose values are of different types.
     */
    public void setInstanceMultiParam(InstanceMultiParam [] InstanceMultiParam) {
        this.InstanceMultiParam = InstanceMultiParam;
    }

    /**
     * Get Number of modifiable parameters supported by the current instance. 
     * @return TotalCount Number of modifiable parameters supported by the current instance.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Number of modifiable parameters supported by the current instance.
     * @param TotalCount Number of modifiable parameters supported by the current instance.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeInstanceParamsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInstanceParamsResponse(DescribeInstanceParamsResponse source) {
        if (source.InstanceEnumParam != null) {
            this.InstanceEnumParam = new InstanceEnumParam[source.InstanceEnumParam.length];
            for (int i = 0; i < source.InstanceEnumParam.length; i++) {
                this.InstanceEnumParam[i] = new InstanceEnumParam(source.InstanceEnumParam[i]);
            }
        }
        if (source.InstanceIntegerParam != null) {
            this.InstanceIntegerParam = new InstanceIntegerParam[source.InstanceIntegerParam.length];
            for (int i = 0; i < source.InstanceIntegerParam.length; i++) {
                this.InstanceIntegerParam[i] = new InstanceIntegerParam(source.InstanceIntegerParam[i]);
            }
        }
        if (source.InstanceTextParam != null) {
            this.InstanceTextParam = new InstanceTextParam[source.InstanceTextParam.length];
            for (int i = 0; i < source.InstanceTextParam.length; i++) {
                this.InstanceTextParam[i] = new InstanceTextParam(source.InstanceTextParam[i]);
            }
        }
        if (source.InstanceMultiParam != null) {
            this.InstanceMultiParam = new InstanceMultiParam[source.InstanceMultiParam.length];
            for (int i = 0; i < source.InstanceMultiParam.length; i++) {
                this.InstanceMultiParam[i] = new InstanceMultiParam(source.InstanceMultiParam[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "InstanceEnumParam.", this.InstanceEnumParam);
        this.setParamArrayObj(map, prefix + "InstanceIntegerParam.", this.InstanceIntegerParam);
        this.setParamArrayObj(map, prefix + "InstanceTextParam.", this.InstanceTextParam);
        this.setParamArrayObj(map, prefix + "InstanceMultiParam.", this.InstanceMultiParam);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

