/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.monitor.v20180724.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InstanceGroups extends AbstractModel {

    /**
    * Instance group ID
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * Instance group name
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
     * Get Instance group ID 
     * @return Id Instance group ID
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set Instance group ID
     * @param Id Instance group ID
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get Instance group name 
     * @return Name Instance group name
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Instance group name
     * @param Name Instance group name
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    public InstanceGroups() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InstanceGroups(InstanceGroups source) {
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Name", this.Name);

    }
}

