/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mps.v20190612.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreatePersonSampleResponse extends AbstractModel {

    /**
    * Image information
    */
    @SerializedName("Person")
    @Expose
    private AiSamplePerson Person;

    /**
    * Information of images that failed the verification by facial feature positioning
    */
    @SerializedName("FailFaceInfoSet")
    @Expose
    private AiSampleFailFaceInfo [] FailFaceInfoSet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Image information 
     * @return Person Image information
     */
    public AiSamplePerson getPerson() {
        return this.Person;
    }

    /**
     * Set Image information
     * @param Person Image information
     */
    public void setPerson(AiSamplePerson Person) {
        this.Person = Person;
    }

    /**
     * Get Information of images that failed the verification by facial feature positioning 
     * @return FailFaceInfoSet Information of images that failed the verification by facial feature positioning
     */
    public AiSampleFailFaceInfo [] getFailFaceInfoSet() {
        return this.FailFaceInfoSet;
    }

    /**
     * Set Information of images that failed the verification by facial feature positioning
     * @param FailFaceInfoSet Information of images that failed the verification by facial feature positioning
     */
    public void setFailFaceInfoSet(AiSampleFailFaceInfo [] FailFaceInfoSet) {
        this.FailFaceInfoSet = FailFaceInfoSet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public CreatePersonSampleResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreatePersonSampleResponse(CreatePersonSampleResponse source) {
        if (source.Person != null) {
            this.Person = new AiSamplePerson(source.Person);
        }
        if (source.FailFaceInfoSet != null) {
            this.FailFaceInfoSet = new AiSampleFailFaceInfo[source.FailFaceInfoSet.length];
            for (int i = 0; i < source.FailFaceInfoSet.length; i++) {
                this.FailFaceInfoSet[i] = new AiSampleFailFaceInfo(source.FailFaceInfoSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "Person.", this.Person);
        this.setParamArrayObj(map, prefix + "FailFaceInfoSet.", this.FailFaceInfoSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

