/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mps.v20190612.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAsrHotwordsListResponse extends AbstractModel {

    /**
    * Total number of hotword lexicons.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Paging offset. Default value: 0.
    */
    @SerializedName("Offset")
    @Expose
    private Long Offset;

    /**
    * Number of returned entries. All hotword lexicons are returned by default.
    */
    @SerializedName("Limit")
    @Expose
    private Long Limit;

    /**
    * Hotword lexicon list.
    */
    @SerializedName("AsrHotwordsSet")
    @Expose
    private AsrHotwordsSet [] AsrHotwordsSet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of hotword lexicons. 
     * @return TotalCount Total number of hotword lexicons.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of hotword lexicons.
     * @param TotalCount Total number of hotword lexicons.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Paging offset. Default value: 0. 
     * @return Offset Paging offset. Default value: 0.
     */
    public Long getOffset() {
        return this.Offset;
    }

    /**
     * Set Paging offset. Default value: 0.
     * @param Offset Paging offset. Default value: 0.
     */
    public void setOffset(Long Offset) {
        this.Offset = Offset;
    }

    /**
     * Get Number of returned entries. All hotword lexicons are returned by default. 
     * @return Limit Number of returned entries. All hotword lexicons are returned by default.
     */
    public Long getLimit() {
        return this.Limit;
    }

    /**
     * Set Number of returned entries. All hotword lexicons are returned by default.
     * @param Limit Number of returned entries. All hotword lexicons are returned by default.
     */
    public void setLimit(Long Limit) {
        this.Limit = Limit;
    }

    /**
     * Get Hotword lexicon list. 
     * @return AsrHotwordsSet Hotword lexicon list.
     */
    public AsrHotwordsSet [] getAsrHotwordsSet() {
        return this.AsrHotwordsSet;
    }

    /**
     * Set Hotword lexicon list.
     * @param AsrHotwordsSet Hotword lexicon list.
     */
    public void setAsrHotwordsSet(AsrHotwordsSet [] AsrHotwordsSet) {
        this.AsrHotwordsSet = AsrHotwordsSet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAsrHotwordsListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAsrHotwordsListResponse(DescribeAsrHotwordsListResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.Offset != null) {
            this.Offset = new Long(source.Offset);
        }
        if (source.Limit != null) {
            this.Limit = new Long(source.Limit);
        }
        if (source.AsrHotwordsSet != null) {
            this.AsrHotwordsSet = new AsrHotwordsSet[source.AsrHotwordsSet.length];
            for (int i = 0; i < source.AsrHotwordsSet.length; i++) {
                this.AsrHotwordsSet[i] = new AsrHotwordsSet(source.AsrHotwordsSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "Offset", this.Offset);
        this.setParamSimple(map, prefix + "Limit", this.Limit);
        this.setParamArrayObj(map, prefix + "AsrHotwordsSet.", this.AsrHotwordsSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

