/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mps.v20190612.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ImageTaskInput extends AbstractModel {

    /**
    * Image encoding configuration.
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("EncodeConfig")
    @Expose
    private ImageEncodeConfig EncodeConfig;

    /**
    * Image enhancement configuration.
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("EnhanceConfig")
    @Expose
    private ImageEnhanceConfig EnhanceConfig;

    /**
    * Image erasing configuration.
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("EraseConfig")
    @Expose
    private ImageEraseConfig EraseConfig;

    /**
     * Get Image encoding configuration.
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return EncodeConfig Image encoding configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public ImageEncodeConfig getEncodeConfig() {
        return this.EncodeConfig;
    }

    /**
     * Set Image encoding configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     * @param EncodeConfig Image encoding configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setEncodeConfig(ImageEncodeConfig EncodeConfig) {
        this.EncodeConfig = EncodeConfig;
    }

    /**
     * Get Image enhancement configuration.
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return EnhanceConfig Image enhancement configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public ImageEnhanceConfig getEnhanceConfig() {
        return this.EnhanceConfig;
    }

    /**
     * Set Image enhancement configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     * @param EnhanceConfig Image enhancement configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setEnhanceConfig(ImageEnhanceConfig EnhanceConfig) {
        this.EnhanceConfig = EnhanceConfig;
    }

    /**
     * Get Image erasing configuration.
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return EraseConfig Image erasing configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public ImageEraseConfig getEraseConfig() {
        return this.EraseConfig;
    }

    /**
     * Set Image erasing configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     * @param EraseConfig Image erasing configuration.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setEraseConfig(ImageEraseConfig EraseConfig) {
        this.EraseConfig = EraseConfig;
    }

    public ImageTaskInput() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ImageTaskInput(ImageTaskInput source) {
        if (source.EncodeConfig != null) {
            this.EncodeConfig = new ImageEncodeConfig(source.EncodeConfig);
        }
        if (source.EnhanceConfig != null) {
            this.EnhanceConfig = new ImageEnhanceConfig(source.EnhanceConfig);
        }
        if (source.EraseConfig != null) {
            this.EraseConfig = new ImageEraseConfig(source.EraseConfig);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "EncodeConfig.", this.EncodeConfig);
        this.setParamObj(map, prefix + "EnhanceConfig.", this.EnhanceConfig);
        this.setParamObj(map, prefix + "EraseConfig.", this.EraseConfig);

    }
}

