/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mps.v20190612.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifySmartSubtitleTemplateRequest extends AbstractModel {

    /**
    * Unique identifier of the smart subtitle template.
    */
    @SerializedName("Definition")
    @Expose
    private Long Definition;

    /**
    * Subtitle translation switch.
ON: enable translation
OFF: disable translation
    */
    @SerializedName("TranslateSwitch")
    @Expose
    private String TranslateSwitch;

    /**
    * Smart subtitle template name.
Length limit: 64 characters.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Smart subtitle template description.
Length limit: 256 characters.
    */
    @SerializedName("Comment")
    @Expose
    private String Comment;

    /**
    * Video source language for intelligent caption.
Valid values: 
zh: Simplified Chinese.
en: Eenglish.
Ja: Japanese.
Ko: Korean.
zh-PY: Simplified Chinese, English and Cantonese.
zh-medical: Medical Chinese.
yue: Cantonese.
Vi: Vietnamese.
ms: Malay.
id: Indonesian.
fil: Filipino.
th: Thai.
pt: Portuguese.
tr: Turkish.
ar: Arabic.
es: Spanish.
hi: Hindi
Fr: French.
de: German.
zh-dialect: Chinese dialect
zh_en: Simplified Chinese and English
prime_zh: Simplified Chinese, Chinese Dialect and English.

    */
    @SerializedName("VideoSrcLanguage")
    @Expose
    private String VideoSrcLanguage;

    /**
    * Intelligent subtitle file format.
vtt: WebVTT format.
srt: SRT format.
If this field is left blank, no subtitle file will be generated.
    */
    @SerializedName("SubtitleFormat")
    @Expose
    private String SubtitleFormat;

    /**
    * Smart subtitle language type.
0: source language
1: target language
2: source language + target language
The value can only be 0 when TranslateSwitch is set to OFF. The value can only be 1 or 2 when TranslateSwitch is set to ON.
    */
    @SerializedName("SubtitleType")
    @Expose
    private Long SubtitleType;

    /**
    * ASR hotword lexicon parameter.
    */
    @SerializedName("AsrHotWordsConfigure")
    @Expose
    private AsrHotWordsConfigure AsrHotWordsConfigure;

    /**
    * Target language for subtitle translation.
This field takes effect when TranslateSwitch is set to ON.
Supported languages:
zh: Simplified Chinese
en: English
ja: Japanese
ko: Korean
fr: French
es: Spanish
it: Italian
de: German
tr: Turkish
ru: Russian
pt: Portuguese
vi: Vietnamese
id: Indonesian
ms: Malay
th: Thai
ar: Arabic
hi: Hindi
    */
    @SerializedName("TranslateDstLanguage")
    @Expose
    private String TranslateDstLanguage;

    /**
     * Get Unique identifier of the smart subtitle template. 
     * @return Definition Unique identifier of the smart subtitle template.
     */
    public Long getDefinition() {
        return this.Definition;
    }

    /**
     * Set Unique identifier of the smart subtitle template.
     * @param Definition Unique identifier of the smart subtitle template.
     */
    public void setDefinition(Long Definition) {
        this.Definition = Definition;
    }

    /**
     * Get Subtitle translation switch.
ON: enable translation
OFF: disable translation 
     * @return TranslateSwitch Subtitle translation switch.
ON: enable translation
OFF: disable translation
     */
    public String getTranslateSwitch() {
        return this.TranslateSwitch;
    }

    /**
     * Set Subtitle translation switch.
ON: enable translation
OFF: disable translation
     * @param TranslateSwitch Subtitle translation switch.
ON: enable translation
OFF: disable translation
     */
    public void setTranslateSwitch(String TranslateSwitch) {
        this.TranslateSwitch = TranslateSwitch;
    }

    /**
     * Get Smart subtitle template name.
Length limit: 64 characters. 
     * @return Name Smart subtitle template name.
Length limit: 64 characters.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Smart subtitle template name.
Length limit: 64 characters.
     * @param Name Smart subtitle template name.
Length limit: 64 characters.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Smart subtitle template description.
Length limit: 256 characters. 
     * @return Comment Smart subtitle template description.
Length limit: 256 characters.
     */
    public String getComment() {
        return this.Comment;
    }

    /**
     * Set Smart subtitle template description.
Length limit: 256 characters.
     * @param Comment Smart subtitle template description.
Length limit: 256 characters.
     */
    public void setComment(String Comment) {
        this.Comment = Comment;
    }

    /**
     * Get Video source language for intelligent caption.
Valid values: 
zh: Simplified Chinese.
en: Eenglish.
Ja: Japanese.
Ko: Korean.
zh-PY: Simplified Chinese, English and Cantonese.
zh-medical: Medical Chinese.
yue: Cantonese.
Vi: Vietnamese.
ms: Malay.
id: Indonesian.
fil: Filipino.
th: Thai.
pt: Portuguese.
tr: Turkish.
ar: Arabic.
es: Spanish.
hi: Hindi
Fr: French.
de: German.
zh-dialect: Chinese dialect
zh_en: Simplified Chinese and English
prime_zh: Simplified Chinese, Chinese Dialect and English.
 
     * @return VideoSrcLanguage Video source language for intelligent caption.
Valid values: 
zh: Simplified Chinese.
en: Eenglish.
Ja: Japanese.
Ko: Korean.
zh-PY: Simplified Chinese, English and Cantonese.
zh-medical: Medical Chinese.
yue: Cantonese.
Vi: Vietnamese.
ms: Malay.
id: Indonesian.
fil: Filipino.
th: Thai.
pt: Portuguese.
tr: Turkish.
ar: Arabic.
es: Spanish.
hi: Hindi
Fr: French.
de: German.
zh-dialect: Chinese dialect
zh_en: Simplified Chinese and English
prime_zh: Simplified Chinese, Chinese Dialect and English.

     */
    public String getVideoSrcLanguage() {
        return this.VideoSrcLanguage;
    }

    /**
     * Set Video source language for intelligent caption.
Valid values: 
zh: Simplified Chinese.
en: Eenglish.
Ja: Japanese.
Ko: Korean.
zh-PY: Simplified Chinese, English and Cantonese.
zh-medical: Medical Chinese.
yue: Cantonese.
Vi: Vietnamese.
ms: Malay.
id: Indonesian.
fil: Filipino.
th: Thai.
pt: Portuguese.
tr: Turkish.
ar: Arabic.
es: Spanish.
hi: Hindi
Fr: French.
de: German.
zh-dialect: Chinese dialect
zh_en: Simplified Chinese and English
prime_zh: Simplified Chinese, Chinese Dialect and English.

     * @param VideoSrcLanguage Video source language for intelligent caption.
Valid values: 
zh: Simplified Chinese.
en: Eenglish.
Ja: Japanese.
Ko: Korean.
zh-PY: Simplified Chinese, English and Cantonese.
zh-medical: Medical Chinese.
yue: Cantonese.
Vi: Vietnamese.
ms: Malay.
id: Indonesian.
fil: Filipino.
th: Thai.
pt: Portuguese.
tr: Turkish.
ar: Arabic.
es: Spanish.
hi: Hindi
Fr: French.
de: German.
zh-dialect: Chinese dialect
zh_en: Simplified Chinese and English
prime_zh: Simplified Chinese, Chinese Dialect and English.

     */
    public void setVideoSrcLanguage(String VideoSrcLanguage) {
        this.VideoSrcLanguage = VideoSrcLanguage;
    }

    /**
     * Get Intelligent subtitle file format.
vtt: WebVTT format.
srt: SRT format.
If this field is left blank, no subtitle file will be generated. 
     * @return SubtitleFormat Intelligent subtitle file format.
vtt: WebVTT format.
srt: SRT format.
If this field is left blank, no subtitle file will be generated.
     */
    public String getSubtitleFormat() {
        return this.SubtitleFormat;
    }

    /**
     * Set Intelligent subtitle file format.
vtt: WebVTT format.
srt: SRT format.
If this field is left blank, no subtitle file will be generated.
     * @param SubtitleFormat Intelligent subtitle file format.
vtt: WebVTT format.
srt: SRT format.
If this field is left blank, no subtitle file will be generated.
     */
    public void setSubtitleFormat(String SubtitleFormat) {
        this.SubtitleFormat = SubtitleFormat;
    }

    /**
     * Get Smart subtitle language type.
0: source language
1: target language
2: source language + target language
The value can only be 0 when TranslateSwitch is set to OFF. The value can only be 1 or 2 when TranslateSwitch is set to ON. 
     * @return SubtitleType Smart subtitle language type.
0: source language
1: target language
2: source language + target language
The value can only be 0 when TranslateSwitch is set to OFF. The value can only be 1 or 2 when TranslateSwitch is set to ON.
     */
    public Long getSubtitleType() {
        return this.SubtitleType;
    }

    /**
     * Set Smart subtitle language type.
0: source language
1: target language
2: source language + target language
The value can only be 0 when TranslateSwitch is set to OFF. The value can only be 1 or 2 when TranslateSwitch is set to ON.
     * @param SubtitleType Smart subtitle language type.
0: source language
1: target language
2: source language + target language
The value can only be 0 when TranslateSwitch is set to OFF. The value can only be 1 or 2 when TranslateSwitch is set to ON.
     */
    public void setSubtitleType(Long SubtitleType) {
        this.SubtitleType = SubtitleType;
    }

    /**
     * Get ASR hotword lexicon parameter. 
     * @return AsrHotWordsConfigure ASR hotword lexicon parameter.
     */
    public AsrHotWordsConfigure getAsrHotWordsConfigure() {
        return this.AsrHotWordsConfigure;
    }

    /**
     * Set ASR hotword lexicon parameter.
     * @param AsrHotWordsConfigure ASR hotword lexicon parameter.
     */
    public void setAsrHotWordsConfigure(AsrHotWordsConfigure AsrHotWordsConfigure) {
        this.AsrHotWordsConfigure = AsrHotWordsConfigure;
    }

    /**
     * Get Target language for subtitle translation.
This field takes effect when TranslateSwitch is set to ON.
Supported languages:
zh: Simplified Chinese
en: English
ja: Japanese
ko: Korean
fr: French
es: Spanish
it: Italian
de: German
tr: Turkish
ru: Russian
pt: Portuguese
vi: Vietnamese
id: Indonesian
ms: Malay
th: Thai
ar: Arabic
hi: Hindi 
     * @return TranslateDstLanguage Target language for subtitle translation.
This field takes effect when TranslateSwitch is set to ON.
Supported languages:
zh: Simplified Chinese
en: English
ja: Japanese
ko: Korean
fr: French
es: Spanish
it: Italian
de: German
tr: Turkish
ru: Russian
pt: Portuguese
vi: Vietnamese
id: Indonesian
ms: Malay
th: Thai
ar: Arabic
hi: Hindi
     */
    public String getTranslateDstLanguage() {
        return this.TranslateDstLanguage;
    }

    /**
     * Set Target language for subtitle translation.
This field takes effect when TranslateSwitch is set to ON.
Supported languages:
zh: Simplified Chinese
en: English
ja: Japanese
ko: Korean
fr: French
es: Spanish
it: Italian
de: German
tr: Turkish
ru: Russian
pt: Portuguese
vi: Vietnamese
id: Indonesian
ms: Malay
th: Thai
ar: Arabic
hi: Hindi
     * @param TranslateDstLanguage Target language for subtitle translation.
This field takes effect when TranslateSwitch is set to ON.
Supported languages:
zh: Simplified Chinese
en: English
ja: Japanese
ko: Korean
fr: French
es: Spanish
it: Italian
de: German
tr: Turkish
ru: Russian
pt: Portuguese
vi: Vietnamese
id: Indonesian
ms: Malay
th: Thai
ar: Arabic
hi: Hindi
     */
    public void setTranslateDstLanguage(String TranslateDstLanguage) {
        this.TranslateDstLanguage = TranslateDstLanguage;
    }

    public ModifySmartSubtitleTemplateRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifySmartSubtitleTemplateRequest(ModifySmartSubtitleTemplateRequest source) {
        if (source.Definition != null) {
            this.Definition = new Long(source.Definition);
        }
        if (source.TranslateSwitch != null) {
            this.TranslateSwitch = new String(source.TranslateSwitch);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Comment != null) {
            this.Comment = new String(source.Comment);
        }
        if (source.VideoSrcLanguage != null) {
            this.VideoSrcLanguage = new String(source.VideoSrcLanguage);
        }
        if (source.SubtitleFormat != null) {
            this.SubtitleFormat = new String(source.SubtitleFormat);
        }
        if (source.SubtitleType != null) {
            this.SubtitleType = new Long(source.SubtitleType);
        }
        if (source.AsrHotWordsConfigure != null) {
            this.AsrHotWordsConfigure = new AsrHotWordsConfigure(source.AsrHotWordsConfigure);
        }
        if (source.TranslateDstLanguage != null) {
            this.TranslateDstLanguage = new String(source.TranslateDstLanguage);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Definition", this.Definition);
        this.setParamSimple(map, prefix + "TranslateSwitch", this.TranslateSwitch);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Comment", this.Comment);
        this.setParamSimple(map, prefix + "VideoSrcLanguage", this.VideoSrcLanguage);
        this.setParamSimple(map, prefix + "SubtitleFormat", this.SubtitleFormat);
        this.setParamSimple(map, prefix + "SubtitleType", this.SubtitleType);
        this.setParamObj(map, prefix + "AsrHotWordsConfigure.", this.AsrHotWordsConfigure);
        this.setParamSimple(map, prefix + "TranslateDstLanguage", this.TranslateDstLanguage);

    }
}

