/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ExtractDocMultiResponse extends AbstractModel {

    /**
    * Image rotation angle (angle system). the text's horizontal direction is 0. clockwise is positive; counterclockwise is negative.
    */
    @SerializedName("Angle")
    @Expose
    private Float Angle;

    /**
    * Configures the structured text info.
    */
    @SerializedName("StructuralList")
    @Expose
    private GroupInfo [] StructuralList;

    /**
    * Restore text information.
    */
    @SerializedName("WordList")
    @Expose
    private WordItem [] WordList;

    /**
    * Number of sample identification fields.
    */
    @SerializedName("TokenNum")
    @Expose
    private Long TokenNum;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Image rotation angle (angle system). the text's horizontal direction is 0. clockwise is positive; counterclockwise is negative. 
     * @return Angle Image rotation angle (angle system). the text's horizontal direction is 0. clockwise is positive; counterclockwise is negative.
     */
    public Float getAngle() {
        return this.Angle;
    }

    /**
     * Set Image rotation angle (angle system). the text's horizontal direction is 0. clockwise is positive; counterclockwise is negative.
     * @param Angle Image rotation angle (angle system). the text's horizontal direction is 0. clockwise is positive; counterclockwise is negative.
     */
    public void setAngle(Float Angle) {
        this.Angle = Angle;
    }

    /**
     * Get Configures the structured text info. 
     * @return StructuralList Configures the structured text info.
     */
    public GroupInfo [] getStructuralList() {
        return this.StructuralList;
    }

    /**
     * Set Configures the structured text info.
     * @param StructuralList Configures the structured text info.
     */
    public void setStructuralList(GroupInfo [] StructuralList) {
        this.StructuralList = StructuralList;
    }

    /**
     * Get Restore text information. 
     * @return WordList Restore text information.
     */
    public WordItem [] getWordList() {
        return this.WordList;
    }

    /**
     * Set Restore text information.
     * @param WordList Restore text information.
     */
    public void setWordList(WordItem [] WordList) {
        this.WordList = WordList;
    }

    /**
     * Get Number of sample identification fields. 
     * @return TokenNum Number of sample identification fields.
     */
    public Long getTokenNum() {
        return this.TokenNum;
    }

    /**
     * Set Number of sample identification fields.
     * @param TokenNum Number of sample identification fields.
     */
    public void setTokenNum(Long TokenNum) {
        this.TokenNum = TokenNum;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ExtractDocMultiResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ExtractDocMultiResponse(ExtractDocMultiResponse source) {
        if (source.Angle != null) {
            this.Angle = new Float(source.Angle);
        }
        if (source.StructuralList != null) {
            this.StructuralList = new GroupInfo[source.StructuralList.length];
            for (int i = 0; i < source.StructuralList.length; i++) {
                this.StructuralList[i] = new GroupInfo(source.StructuralList[i]);
            }
        }
        if (source.WordList != null) {
            this.WordList = new WordItem[source.WordList.length];
            for (int i = 0; i < source.WordList.length; i++) {
                this.WordList[i] = new WordItem(source.WordList[i]);
            }
        }
        if (source.TokenNum != null) {
            this.TokenNum = new Long(source.TokenNum);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Angle", this.Angle);
        this.setParamArrayObj(map, prefix + "StructuralList.", this.StructuralList);
        this.setParamArrayObj(map, prefix + "WordList.", this.WordList);
        this.setParamSimple(map, prefix + "TokenNum", this.TokenNum);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

