/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MLIDPassportOCRResponse extends AbstractModel {

    /**
    * Passport ID
    */
    @SerializedName("ID")
    @Expose
    private String ID;

    /**
    * Name
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Date of birth
    */
    @SerializedName("DateOfBirth")
    @Expose
    private String DateOfBirth;

    /**
    * Gender (F: female, M: male)
    */
    @SerializedName("Sex")
    @Expose
    private String Sex;

    /**
    * Expiration date
    */
    @SerializedName("DateOfExpiration")
    @Expose
    private String DateOfExpiration;

    /**
    * Issuing country
    */
    @SerializedName("IssuingCountry")
    @Expose
    private String IssuingCountry;

    /**
    * Country/region code
    */
    @SerializedName("Nationality")
    @Expose
    private String Nationality;

    /**
    * This field is deprecated and will always return an empty array. Usage is not recommended.
    */
    @SerializedName("Warn")
    @Expose
    private Long [] Warn;

    /**
    * Identity photo
    */
    @SerializedName("Image")
    @Expose
    private String Image;

    /**
    * This field is deprecated and will always return "1". Usage is not recommended.
    */
    @SerializedName("AdvancedInfo")
    @Expose
    private String AdvancedInfo;

    /**
    * The first row of the machine-readable zone (MRZ) at the bottom
    */
    @SerializedName("CodeSet")
    @Expose
    private String CodeSet;

    /**
    * The second row of the MRZ at the bottom
    */
    @SerializedName("CodeCrc")
    @Expose
    private String CodeCrc;

    /**
    * The surname.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Surname")
    @Expose
    private String Surname;

    /**
    * The given name.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("GivenName")
    @Expose
    private String GivenName;

    /**
    * Type (in Machine Readable Zone)
    */
    @SerializedName("Type")
    @Expose
    private String Type;

    /**
    * Document content in Information Zone
    */
    @SerializedName("PassportRecognizeInfos")
    @Expose
    private PassportRecognizeInfos PassportRecognizeInfos;

    /**
    * Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
    */
    @SerializedName("WarnCardInfos")
    @Expose
    private Long [] WarnCardInfos;

    /**
    * The number of cards detected in the input image.(Currently supported only in ap-bangkok region)
    */
    @SerializedName("CardCount")
    @Expose
    private Long CardCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Passport ID 
     * @return ID Passport ID
     */
    public String getID() {
        return this.ID;
    }

    /**
     * Set Passport ID
     * @param ID Passport ID
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /**
     * Get Name 
     * @return Name Name
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Name
     * @param Name Name
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Date of birth 
     * @return DateOfBirth Date of birth
     */
    public String getDateOfBirth() {
        return this.DateOfBirth;
    }

    /**
     * Set Date of birth
     * @param DateOfBirth Date of birth
     */
    public void setDateOfBirth(String DateOfBirth) {
        this.DateOfBirth = DateOfBirth;
    }

    /**
     * Get Gender (F: female, M: male) 
     * @return Sex Gender (F: female, M: male)
     */
    public String getSex() {
        return this.Sex;
    }

    /**
     * Set Gender (F: female, M: male)
     * @param Sex Gender (F: female, M: male)
     */
    public void setSex(String Sex) {
        this.Sex = Sex;
    }

    /**
     * Get Expiration date 
     * @return DateOfExpiration Expiration date
     */
    public String getDateOfExpiration() {
        return this.DateOfExpiration;
    }

    /**
     * Set Expiration date
     * @param DateOfExpiration Expiration date
     */
    public void setDateOfExpiration(String DateOfExpiration) {
        this.DateOfExpiration = DateOfExpiration;
    }

    /**
     * Get Issuing country 
     * @return IssuingCountry Issuing country
     */
    public String getIssuingCountry() {
        return this.IssuingCountry;
    }

    /**
     * Set Issuing country
     * @param IssuingCountry Issuing country
     */
    public void setIssuingCountry(String IssuingCountry) {
        this.IssuingCountry = IssuingCountry;
    }

    /**
     * Get Country/region code 
     * @return Nationality Country/region code
     */
    public String getNationality() {
        return this.Nationality;
    }

    /**
     * Set Country/region code
     * @param Nationality Country/region code
     */
    public void setNationality(String Nationality) {
        this.Nationality = Nationality;
    }

    /**
     * Get This field is deprecated and will always return an empty array. Usage is not recommended. 
     * @return Warn This field is deprecated and will always return an empty array. Usage is not recommended.
     * @deprecated
     */
    @Deprecated
    public Long [] getWarn() {
        return this.Warn;
    }

    /**
     * Set This field is deprecated and will always return an empty array. Usage is not recommended.
     * @param Warn This field is deprecated and will always return an empty array. Usage is not recommended.
     * @deprecated
     */
    @Deprecated
    public void setWarn(Long [] Warn) {
        this.Warn = Warn;
    }

    /**
     * Get Identity photo 
     * @return Image Identity photo
     */
    public String getImage() {
        return this.Image;
    }

    /**
     * Set Identity photo
     * @param Image Identity photo
     */
    public void setImage(String Image) {
        this.Image = Image;
    }

    /**
     * Get This field is deprecated and will always return "1". Usage is not recommended. 
     * @return AdvancedInfo This field is deprecated and will always return "1". Usage is not recommended.
     * @deprecated
     */
    @Deprecated
    public String getAdvancedInfo() {
        return this.AdvancedInfo;
    }

    /**
     * Set This field is deprecated and will always return "1". Usage is not recommended.
     * @param AdvancedInfo This field is deprecated and will always return "1". Usage is not recommended.
     * @deprecated
     */
    @Deprecated
    public void setAdvancedInfo(String AdvancedInfo) {
        this.AdvancedInfo = AdvancedInfo;
    }

    /**
     * Get The first row of the machine-readable zone (MRZ) at the bottom 
     * @return CodeSet The first row of the machine-readable zone (MRZ) at the bottom
     */
    public String getCodeSet() {
        return this.CodeSet;
    }

    /**
     * Set The first row of the machine-readable zone (MRZ) at the bottom
     * @param CodeSet The first row of the machine-readable zone (MRZ) at the bottom
     */
    public void setCodeSet(String CodeSet) {
        this.CodeSet = CodeSet;
    }

    /**
     * Get The second row of the MRZ at the bottom 
     * @return CodeCrc The second row of the MRZ at the bottom
     */
    public String getCodeCrc() {
        return this.CodeCrc;
    }

    /**
     * Set The second row of the MRZ at the bottom
     * @param CodeCrc The second row of the MRZ at the bottom
     */
    public void setCodeCrc(String CodeCrc) {
        this.CodeCrc = CodeCrc;
    }

    /**
     * Get The surname.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Surname The surname.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getSurname() {
        return this.Surname;
    }

    /**
     * Set The surname.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Surname The surname.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setSurname(String Surname) {
        this.Surname = Surname;
    }

    /**
     * Get The given name.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return GivenName The given name.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getGivenName() {
        return this.GivenName;
    }

    /**
     * Set The given name.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param GivenName The given name.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setGivenName(String GivenName) {
        this.GivenName = GivenName;
    }

    /**
     * Get Type (in Machine Readable Zone) 
     * @return Type Type (in Machine Readable Zone)
     */
    public String getType() {
        return this.Type;
    }

    /**
     * Set Type (in Machine Readable Zone)
     * @param Type Type (in Machine Readable Zone)
     */
    public void setType(String Type) {
        this.Type = Type;
    }

    /**
     * Get Document content in Information Zone 
     * @return PassportRecognizeInfos Document content in Information Zone
     */
    public PassportRecognizeInfos getPassportRecognizeInfos() {
        return this.PassportRecognizeInfos;
    }

    /**
     * Set Document content in Information Zone
     * @param PassportRecognizeInfos Document content in Information Zone
     */
    public void setPassportRecognizeInfos(PassportRecognizeInfos PassportRecognizeInfos) {
        this.PassportRecognizeInfos = PassportRecognizeInfos;
    }

    /**
     * Get Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled. 
     * @return WarnCardInfos Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     */
    public Long [] getWarnCardInfos() {
        return this.WarnCardInfos;
    }

    /**
     * Set Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     * @param WarnCardInfos Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     */
    public void setWarnCardInfos(Long [] WarnCardInfos) {
        this.WarnCardInfos = WarnCardInfos;
    }

    /**
     * Get The number of cards detected in the input image.(Currently supported only in ap-bangkok region) 
     * @return CardCount The number of cards detected in the input image.(Currently supported only in ap-bangkok region)
     */
    public Long getCardCount() {
        return this.CardCount;
    }

    /**
     * Set The number of cards detected in the input image.(Currently supported only in ap-bangkok region)
     * @param CardCount The number of cards detected in the input image.(Currently supported only in ap-bangkok region)
     */
    public void setCardCount(Long CardCount) {
        this.CardCount = CardCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public MLIDPassportOCRResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MLIDPassportOCRResponse(MLIDPassportOCRResponse source) {
        if (source.ID != null) {
            this.ID = new String(source.ID);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.DateOfBirth != null) {
            this.DateOfBirth = new String(source.DateOfBirth);
        }
        if (source.Sex != null) {
            this.Sex = new String(source.Sex);
        }
        if (source.DateOfExpiration != null) {
            this.DateOfExpiration = new String(source.DateOfExpiration);
        }
        if (source.IssuingCountry != null) {
            this.IssuingCountry = new String(source.IssuingCountry);
        }
        if (source.Nationality != null) {
            this.Nationality = new String(source.Nationality);
        }
        if (source.Warn != null) {
            this.Warn = new Long[source.Warn.length];
            for (int i = 0; i < source.Warn.length; i++) {
                this.Warn[i] = new Long(source.Warn[i]);
            }
        }
        if (source.Image != null) {
            this.Image = new String(source.Image);
        }
        if (source.AdvancedInfo != null) {
            this.AdvancedInfo = new String(source.AdvancedInfo);
        }
        if (source.CodeSet != null) {
            this.CodeSet = new String(source.CodeSet);
        }
        if (source.CodeCrc != null) {
            this.CodeCrc = new String(source.CodeCrc);
        }
        if (source.Surname != null) {
            this.Surname = new String(source.Surname);
        }
        if (source.GivenName != null) {
            this.GivenName = new String(source.GivenName);
        }
        if (source.Type != null) {
            this.Type = new String(source.Type);
        }
        if (source.PassportRecognizeInfos != null) {
            this.PassportRecognizeInfos = new PassportRecognizeInfos(source.PassportRecognizeInfos);
        }
        if (source.WarnCardInfos != null) {
            this.WarnCardInfos = new Long[source.WarnCardInfos.length];
            for (int i = 0; i < source.WarnCardInfos.length; i++) {
                this.WarnCardInfos[i] = new Long(source.WarnCardInfos[i]);
            }
        }
        if (source.CardCount != null) {
            this.CardCount = new Long(source.CardCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ID", this.ID);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "DateOfBirth", this.DateOfBirth);
        this.setParamSimple(map, prefix + "Sex", this.Sex);
        this.setParamSimple(map, prefix + "DateOfExpiration", this.DateOfExpiration);
        this.setParamSimple(map, prefix + "IssuingCountry", this.IssuingCountry);
        this.setParamSimple(map, prefix + "Nationality", this.Nationality);
        this.setParamArraySimple(map, prefix + "Warn.", this.Warn);
        this.setParamSimple(map, prefix + "Image", this.Image);
        this.setParamSimple(map, prefix + "AdvancedInfo", this.AdvancedInfo);
        this.setParamSimple(map, prefix + "CodeSet", this.CodeSet);
        this.setParamSimple(map, prefix + "CodeCrc", this.CodeCrc);
        this.setParamSimple(map, prefix + "Surname", this.Surname);
        this.setParamSimple(map, prefix + "GivenName", this.GivenName);
        this.setParamSimple(map, prefix + "Type", this.Type);
        this.setParamObj(map, prefix + "PassportRecognizeInfos.", this.PassportRecognizeInfos);
        this.setParamArraySimple(map, prefix + "WarnCardInfos.", this.WarnCardInfos);
        this.setParamSimple(map, prefix + "CardCount", this.CardCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

