/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecognizeBrazilDriverLicenseOCRResponse extends AbstractModel {

    /**
    * Name
    */
    @SerializedName("NOME")
    @Expose
    private String NOME;

    /**
    * Driving license type
    */
    @SerializedName("CatHab")
    @Expose
    private String CatHab;

    /**
    * CNH number
    */
    @SerializedName("CNHNumber")
    @Expose
    private String CNHNumber;

    /**
    * Valid date
    */
    @SerializedName("VALIDADE")
    @Expose
    private String VALIDADE;

    /**
    * Qualification
    */
    @SerializedName("QUALIFICATION")
    @Expose
    private String QUALIFICATION;

    /**
    * ID number
    */
    @SerializedName("IDENTIDADE")
    @Expose
    private String IDENTIDADE;

    /**
    * CPF
    */
    @SerializedName("CPF")
    @Expose
    private String CPF;

    /**
    * Birthday
    */
    @SerializedName("NASCIMENTO")
    @Expose
    private String NASCIMENTO;

    /**
    * Membership
    */
    @SerializedName("MEMBERSHIP")
    @Expose
    private String MEMBERSHIP;

    /**
    * Registration number
    */
    @SerializedName("REGISTRO")
    @Expose
    private String REGISTRO;

    /**
    * Remark
    */
    @SerializedName("OBSERVATIONS")
    @Expose
    private String OBSERVATIONS;

    /**
    * Issue date
    */
    @SerializedName("IssueDate")
    @Expose
    private String IssueDate;

    /**
    * Issue location
    */
    @SerializedName("LOCAL")
    @Expose
    private String LOCAL;

    /**
    * Number in the back of the card
    */
    @SerializedName("BackNumber")
    @Expose
    private String BackNumber;

    /**
    * Field confidence
    */
    @SerializedName("AdvancedInfo")
    @Expose
    private String AdvancedInfo;

    /**
    * PortraitImage base64
    */
    @SerializedName("PortraitImage")
    @Expose
    private String PortraitImage;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Name 
     * @return NOME Name
     */
    public String getNOME() {
        return this.NOME;
    }

    /**
     * Set Name
     * @param NOME Name
     */
    public void setNOME(String NOME) {
        this.NOME = NOME;
    }

    /**
     * Get Driving license type 
     * @return CatHab Driving license type
     */
    public String getCatHab() {
        return this.CatHab;
    }

    /**
     * Set Driving license type
     * @param CatHab Driving license type
     */
    public void setCatHab(String CatHab) {
        this.CatHab = CatHab;
    }

    /**
     * Get CNH number 
     * @return CNHNumber CNH number
     */
    public String getCNHNumber() {
        return this.CNHNumber;
    }

    /**
     * Set CNH number
     * @param CNHNumber CNH number
     */
    public void setCNHNumber(String CNHNumber) {
        this.CNHNumber = CNHNumber;
    }

    /**
     * Get Valid date 
     * @return VALIDADE Valid date
     */
    public String getVALIDADE() {
        return this.VALIDADE;
    }

    /**
     * Set Valid date
     * @param VALIDADE Valid date
     */
    public void setVALIDADE(String VALIDADE) {
        this.VALIDADE = VALIDADE;
    }

    /**
     * Get Qualification 
     * @return QUALIFICATION Qualification
     */
    public String getQUALIFICATION() {
        return this.QUALIFICATION;
    }

    /**
     * Set Qualification
     * @param QUALIFICATION Qualification
     */
    public void setQUALIFICATION(String QUALIFICATION) {
        this.QUALIFICATION = QUALIFICATION;
    }

    /**
     * Get ID number 
     * @return IDENTIDADE ID number
     */
    public String getIDENTIDADE() {
        return this.IDENTIDADE;
    }

    /**
     * Set ID number
     * @param IDENTIDADE ID number
     */
    public void setIDENTIDADE(String IDENTIDADE) {
        this.IDENTIDADE = IDENTIDADE;
    }

    /**
     * Get CPF 
     * @return CPF CPF
     */
    public String getCPF() {
        return this.CPF;
    }

    /**
     * Set CPF
     * @param CPF CPF
     */
    public void setCPF(String CPF) {
        this.CPF = CPF;
    }

    /**
     * Get Birthday 
     * @return NASCIMENTO Birthday
     */
    public String getNASCIMENTO() {
        return this.NASCIMENTO;
    }

    /**
     * Set Birthday
     * @param NASCIMENTO Birthday
     */
    public void setNASCIMENTO(String NASCIMENTO) {
        this.NASCIMENTO = NASCIMENTO;
    }

    /**
     * Get Membership 
     * @return MEMBERSHIP Membership
     */
    public String getMEMBERSHIP() {
        return this.MEMBERSHIP;
    }

    /**
     * Set Membership
     * @param MEMBERSHIP Membership
     */
    public void setMEMBERSHIP(String MEMBERSHIP) {
        this.MEMBERSHIP = MEMBERSHIP;
    }

    /**
     * Get Registration number 
     * @return REGISTRO Registration number
     */
    public String getREGISTRO() {
        return this.REGISTRO;
    }

    /**
     * Set Registration number
     * @param REGISTRO Registration number
     */
    public void setREGISTRO(String REGISTRO) {
        this.REGISTRO = REGISTRO;
    }

    /**
     * Get Remark 
     * @return OBSERVATIONS Remark
     */
    public String getOBSERVATIONS() {
        return this.OBSERVATIONS;
    }

    /**
     * Set Remark
     * @param OBSERVATIONS Remark
     */
    public void setOBSERVATIONS(String OBSERVATIONS) {
        this.OBSERVATIONS = OBSERVATIONS;
    }

    /**
     * Get Issue date 
     * @return IssueDate Issue date
     */
    public String getIssueDate() {
        return this.IssueDate;
    }

    /**
     * Set Issue date
     * @param IssueDate Issue date
     */
    public void setIssueDate(String IssueDate) {
        this.IssueDate = IssueDate;
    }

    /**
     * Get Issue location 
     * @return LOCAL Issue location
     */
    public String getLOCAL() {
        return this.LOCAL;
    }

    /**
     * Set Issue location
     * @param LOCAL Issue location
     */
    public void setLOCAL(String LOCAL) {
        this.LOCAL = LOCAL;
    }

    /**
     * Get Number in the back of the card 
     * @return BackNumber Number in the back of the card
     */
    public String getBackNumber() {
        return this.BackNumber;
    }

    /**
     * Set Number in the back of the card
     * @param BackNumber Number in the back of the card
     */
    public void setBackNumber(String BackNumber) {
        this.BackNumber = BackNumber;
    }

    /**
     * Get Field confidence 
     * @return AdvancedInfo Field confidence
     */
    public String getAdvancedInfo() {
        return this.AdvancedInfo;
    }

    /**
     * Set Field confidence
     * @param AdvancedInfo Field confidence
     */
    public void setAdvancedInfo(String AdvancedInfo) {
        this.AdvancedInfo = AdvancedInfo;
    }

    /**
     * Get PortraitImage base64 
     * @return PortraitImage PortraitImage base64
     */
    public String getPortraitImage() {
        return this.PortraitImage;
    }

    /**
     * Set PortraitImage base64
     * @param PortraitImage PortraitImage base64
     */
    public void setPortraitImage(String PortraitImage) {
        this.PortraitImage = PortraitImage;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecognizeBrazilDriverLicenseOCRResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecognizeBrazilDriverLicenseOCRResponse(RecognizeBrazilDriverLicenseOCRResponse source) {
        if (source.NOME != null) {
            this.NOME = new String(source.NOME);
        }
        if (source.CatHab != null) {
            this.CatHab = new String(source.CatHab);
        }
        if (source.CNHNumber != null) {
            this.CNHNumber = new String(source.CNHNumber);
        }
        if (source.VALIDADE != null) {
            this.VALIDADE = new String(source.VALIDADE);
        }
        if (source.QUALIFICATION != null) {
            this.QUALIFICATION = new String(source.QUALIFICATION);
        }
        if (source.IDENTIDADE != null) {
            this.IDENTIDADE = new String(source.IDENTIDADE);
        }
        if (source.CPF != null) {
            this.CPF = new String(source.CPF);
        }
        if (source.NASCIMENTO != null) {
            this.NASCIMENTO = new String(source.NASCIMENTO);
        }
        if (source.MEMBERSHIP != null) {
            this.MEMBERSHIP = new String(source.MEMBERSHIP);
        }
        if (source.REGISTRO != null) {
            this.REGISTRO = new String(source.REGISTRO);
        }
        if (source.OBSERVATIONS != null) {
            this.OBSERVATIONS = new String(source.OBSERVATIONS);
        }
        if (source.IssueDate != null) {
            this.IssueDate = new String(source.IssueDate);
        }
        if (source.LOCAL != null) {
            this.LOCAL = new String(source.LOCAL);
        }
        if (source.BackNumber != null) {
            this.BackNumber = new String(source.BackNumber);
        }
        if (source.AdvancedInfo != null) {
            this.AdvancedInfo = new String(source.AdvancedInfo);
        }
        if (source.PortraitImage != null) {
            this.PortraitImage = new String(source.PortraitImage);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "NOME", this.NOME);
        this.setParamSimple(map, prefix + "CatHab", this.CatHab);
        this.setParamSimple(map, prefix + "CNHNumber", this.CNHNumber);
        this.setParamSimple(map, prefix + "VALIDADE", this.VALIDADE);
        this.setParamSimple(map, prefix + "QUALIFICATION", this.QUALIFICATION);
        this.setParamSimple(map, prefix + "IDENTIDADE", this.IDENTIDADE);
        this.setParamSimple(map, prefix + "CPF", this.CPF);
        this.setParamSimple(map, prefix + "NASCIMENTO", this.NASCIMENTO);
        this.setParamSimple(map, prefix + "MEMBERSHIP", this.MEMBERSHIP);
        this.setParamSimple(map, prefix + "REGISTRO", this.REGISTRO);
        this.setParamSimple(map, prefix + "OBSERVATIONS", this.OBSERVATIONS);
        this.setParamSimple(map, prefix + "IssueDate", this.IssueDate);
        this.setParamSimple(map, prefix + "LOCAL", this.LOCAL);
        this.setParamSimple(map, prefix + "BackNumber", this.BackNumber);
        this.setParamSimple(map, prefix + "AdvancedInfo", this.AdvancedInfo);
        this.setParamSimple(map, prefix + "PortraitImage", this.PortraitImage);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

