/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecognizeBrazilIDCardOCRResponse extends AbstractModel {

    /**
    * Name
    */
    @SerializedName("Nome")
    @Expose
    private String Nome;

    /**
    * Family information
    */
    @SerializedName("MemberShip")
    @Expose
    private String MemberShip;

    /**
    * Birthday
    */
    @SerializedName("DataNascimento")
    @Expose
    private String DataNascimento;

    /**
    * Issuing agency
    */
    @SerializedName("IssuingAgency")
    @Expose
    private String IssuingAgency;

    /**
    * blood type
    */
    @SerializedName("Fatorrh")
    @Expose
    private String Fatorrh;

    /**
    * Birth place
    */
    @SerializedName("NaturalIDade")
    @Expose
    private String NaturalIDade;

    /**
    * Additional information 
    */
    @SerializedName("Observations")
    @Expose
    private String Observations;

    /**
    * CPF
    */
    @SerializedName("CPF")
    @Expose
    private String CPF;

    /**
    * DNI
    */
    @SerializedName("DNI")
    @Expose
    private String DNI;

    /**
    * universal registration
    */
    @SerializedName("RegistroGeral")
    @Expose
    private String RegistroGeral;

    /**
    * Issue date
    */
    @SerializedName("DispatchDate")
    @Expose
    private String DispatchDate;

    /**
    * address
    */
    @SerializedName("Registro")
    @Expose
    private String Registro;

    /**
    * Portrait image
    */
    @SerializedName("PortraitImage")
    @Expose
    private String PortraitImage;

    /**
    * Original identity information
    */
    @SerializedName("DocOrigem")
    @Expose
    private String DocOrigem;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Name 
     * @return Nome Name
     */
    public String getNome() {
        return this.Nome;
    }

    /**
     * Set Name
     * @param Nome Name
     */
    public void setNome(String Nome) {
        this.Nome = Nome;
    }

    /**
     * Get Family information 
     * @return MemberShip Family information
     */
    public String getMemberShip() {
        return this.MemberShip;
    }

    /**
     * Set Family information
     * @param MemberShip Family information
     */
    public void setMemberShip(String MemberShip) {
        this.MemberShip = MemberShip;
    }

    /**
     * Get Birthday 
     * @return DataNascimento Birthday
     */
    public String getDataNascimento() {
        return this.DataNascimento;
    }

    /**
     * Set Birthday
     * @param DataNascimento Birthday
     */
    public void setDataNascimento(String DataNascimento) {
        this.DataNascimento = DataNascimento;
    }

    /**
     * Get Issuing agency 
     * @return IssuingAgency Issuing agency
     */
    public String getIssuingAgency() {
        return this.IssuingAgency;
    }

    /**
     * Set Issuing agency
     * @param IssuingAgency Issuing agency
     */
    public void setIssuingAgency(String IssuingAgency) {
        this.IssuingAgency = IssuingAgency;
    }

    /**
     * Get blood type 
     * @return Fatorrh blood type
     */
    public String getFatorrh() {
        return this.Fatorrh;
    }

    /**
     * Set blood type
     * @param Fatorrh blood type
     */
    public void setFatorrh(String Fatorrh) {
        this.Fatorrh = Fatorrh;
    }

    /**
     * Get Birth place 
     * @return NaturalIDade Birth place
     */
    public String getNaturalIDade() {
        return this.NaturalIDade;
    }

    /**
     * Set Birth place
     * @param NaturalIDade Birth place
     */
    public void setNaturalIDade(String NaturalIDade) {
        this.NaturalIDade = NaturalIDade;
    }

    /**
     * Get Additional information  
     * @return Observations Additional information 
     */
    public String getObservations() {
        return this.Observations;
    }

    /**
     * Set Additional information 
     * @param Observations Additional information 
     */
    public void setObservations(String Observations) {
        this.Observations = Observations;
    }

    /**
     * Get CPF 
     * @return CPF CPF
     */
    public String getCPF() {
        return this.CPF;
    }

    /**
     * Set CPF
     * @param CPF CPF
     */
    public void setCPF(String CPF) {
        this.CPF = CPF;
    }

    /**
     * Get DNI 
     * @return DNI DNI
     */
    public String getDNI() {
        return this.DNI;
    }

    /**
     * Set DNI
     * @param DNI DNI
     */
    public void setDNI(String DNI) {
        this.DNI = DNI;
    }

    /**
     * Get universal registration 
     * @return RegistroGeral universal registration
     */
    public String getRegistroGeral() {
        return this.RegistroGeral;
    }

    /**
     * Set universal registration
     * @param RegistroGeral universal registration
     */
    public void setRegistroGeral(String RegistroGeral) {
        this.RegistroGeral = RegistroGeral;
    }

    /**
     * Get Issue date 
     * @return DispatchDate Issue date
     */
    public String getDispatchDate() {
        return this.DispatchDate;
    }

    /**
     * Set Issue date
     * @param DispatchDate Issue date
     */
    public void setDispatchDate(String DispatchDate) {
        this.DispatchDate = DispatchDate;
    }

    /**
     * Get address 
     * @return Registro address
     */
    public String getRegistro() {
        return this.Registro;
    }

    /**
     * Set address
     * @param Registro address
     */
    public void setRegistro(String Registro) {
        this.Registro = Registro;
    }

    /**
     * Get Portrait image 
     * @return PortraitImage Portrait image
     */
    public String getPortraitImage() {
        return this.PortraitImage;
    }

    /**
     * Set Portrait image
     * @param PortraitImage Portrait image
     */
    public void setPortraitImage(String PortraitImage) {
        this.PortraitImage = PortraitImage;
    }

    /**
     * Get Original identity information 
     * @return DocOrigem Original identity information
     */
    public String getDocOrigem() {
        return this.DocOrigem;
    }

    /**
     * Set Original identity information
     * @param DocOrigem Original identity information
     */
    public void setDocOrigem(String DocOrigem) {
        this.DocOrigem = DocOrigem;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecognizeBrazilIDCardOCRResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecognizeBrazilIDCardOCRResponse(RecognizeBrazilIDCardOCRResponse source) {
        if (source.Nome != null) {
            this.Nome = new String(source.Nome);
        }
        if (source.MemberShip != null) {
            this.MemberShip = new String(source.MemberShip);
        }
        if (source.DataNascimento != null) {
            this.DataNascimento = new String(source.DataNascimento);
        }
        if (source.IssuingAgency != null) {
            this.IssuingAgency = new String(source.IssuingAgency);
        }
        if (source.Fatorrh != null) {
            this.Fatorrh = new String(source.Fatorrh);
        }
        if (source.NaturalIDade != null) {
            this.NaturalIDade = new String(source.NaturalIDade);
        }
        if (source.Observations != null) {
            this.Observations = new String(source.Observations);
        }
        if (source.CPF != null) {
            this.CPF = new String(source.CPF);
        }
        if (source.DNI != null) {
            this.DNI = new String(source.DNI);
        }
        if (source.RegistroGeral != null) {
            this.RegistroGeral = new String(source.RegistroGeral);
        }
        if (source.DispatchDate != null) {
            this.DispatchDate = new String(source.DispatchDate);
        }
        if (source.Registro != null) {
            this.Registro = new String(source.Registro);
        }
        if (source.PortraitImage != null) {
            this.PortraitImage = new String(source.PortraitImage);
        }
        if (source.DocOrigem != null) {
            this.DocOrigem = new String(source.DocOrigem);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Nome", this.Nome);
        this.setParamSimple(map, prefix + "MemberShip", this.MemberShip);
        this.setParamSimple(map, prefix + "DataNascimento", this.DataNascimento);
        this.setParamSimple(map, prefix + "IssuingAgency", this.IssuingAgency);
        this.setParamSimple(map, prefix + "Fatorrh", this.Fatorrh);
        this.setParamSimple(map, prefix + "NaturalIDade", this.NaturalIDade);
        this.setParamSimple(map, prefix + "Observations", this.Observations);
        this.setParamSimple(map, prefix + "CPF", this.CPF);
        this.setParamSimple(map, prefix + "DNI", this.DNI);
        this.setParamSimple(map, prefix + "RegistroGeral", this.RegistroGeral);
        this.setParamSimple(map, prefix + "DispatchDate", this.DispatchDate);
        this.setParamSimple(map, prefix + "Registro", this.Registro);
        this.setParamSimple(map, prefix + "PortraitImage", this.PortraitImage);
        this.setParamSimple(map, prefix + "DocOrigem", this.DocOrigem);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

