/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecognizeBrazilRNEOCRResponse extends AbstractModel {

    /**
    * RNE
    */
    @SerializedName("RNE")
    @Expose
    private String RNE;

    /**
    * Classification
    */
    @SerializedName("CLASSIFICATION")
    @Expose
    private String CLASSIFICATION;

    /**
    * Valid date
    */
    @SerializedName("VALIDADE")
    @Expose
    private String VALIDADE;

    /**
    * Name
    */
    @SerializedName("NOME")
    @Expose
    private String NOME;

    /**
    * Family information
    */
    @SerializedName("Membership")
    @Expose
    private String Membership;

    /**
    * Nationality
    */
    @SerializedName("NACIONALIDADE")
    @Expose
    private String NACIONALIDADE;

    /**
    * Place of Birth
    */
    @SerializedName("NATURALIDADE")
    @Expose
    private String NATURALIDADE;

    /**
    * Issuing agency
    */
    @SerializedName("IssuingAgency")
    @Expose
    private String IssuingAgency;

    /**
    * Birthday
    */
    @SerializedName("DateOfBirth")
    @Expose
    private String DateOfBirth;

    /**
    * Gender
    */
    @SerializedName("Sex")
    @Expose
    private String Sex;

    /**
    * Date of entry
    */
    @SerializedName("EntryDate")
    @Expose
    private String EntryDate;

    /**
    * VIA
    */
    @SerializedName("VIA")
    @Expose
    private String VIA;

    /**
    * Dispatch date
    */
    @SerializedName("DispatchDate")
    @Expose
    private String DispatchDate;

    /**
    * MRZ
    */
    @SerializedName("MRZ")
    @Expose
    private String MRZ;

    /**
    * PortraitImage base64
    */
    @SerializedName("PortraitImage")
    @Expose
    private String PortraitImage;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get RNE 
     * @return RNE RNE
     */
    public String getRNE() {
        return this.RNE;
    }

    /**
     * Set RNE
     * @param RNE RNE
     */
    public void setRNE(String RNE) {
        this.RNE = RNE;
    }

    /**
     * Get Classification 
     * @return CLASSIFICATION Classification
     */
    public String getCLASSIFICATION() {
        return this.CLASSIFICATION;
    }

    /**
     * Set Classification
     * @param CLASSIFICATION Classification
     */
    public void setCLASSIFICATION(String CLASSIFICATION) {
        this.CLASSIFICATION = CLASSIFICATION;
    }

    /**
     * Get Valid date 
     * @return VALIDADE Valid date
     */
    public String getVALIDADE() {
        return this.VALIDADE;
    }

    /**
     * Set Valid date
     * @param VALIDADE Valid date
     */
    public void setVALIDADE(String VALIDADE) {
        this.VALIDADE = VALIDADE;
    }

    /**
     * Get Name 
     * @return NOME Name
     */
    public String getNOME() {
        return this.NOME;
    }

    /**
     * Set Name
     * @param NOME Name
     */
    public void setNOME(String NOME) {
        this.NOME = NOME;
    }

    /**
     * Get Family information 
     * @return Membership Family information
     */
    public String getMembership() {
        return this.Membership;
    }

    /**
     * Set Family information
     * @param Membership Family information
     */
    public void setMembership(String Membership) {
        this.Membership = Membership;
    }

    /**
     * Get Nationality 
     * @return NACIONALIDADE Nationality
     */
    public String getNACIONALIDADE() {
        return this.NACIONALIDADE;
    }

    /**
     * Set Nationality
     * @param NACIONALIDADE Nationality
     */
    public void setNACIONALIDADE(String NACIONALIDADE) {
        this.NACIONALIDADE = NACIONALIDADE;
    }

    /**
     * Get Place of Birth 
     * @return NATURALIDADE Place of Birth
     */
    public String getNATURALIDADE() {
        return this.NATURALIDADE;
    }

    /**
     * Set Place of Birth
     * @param NATURALIDADE Place of Birth
     */
    public void setNATURALIDADE(String NATURALIDADE) {
        this.NATURALIDADE = NATURALIDADE;
    }

    /**
     * Get Issuing agency 
     * @return IssuingAgency Issuing agency
     */
    public String getIssuingAgency() {
        return this.IssuingAgency;
    }

    /**
     * Set Issuing agency
     * @param IssuingAgency Issuing agency
     */
    public void setIssuingAgency(String IssuingAgency) {
        this.IssuingAgency = IssuingAgency;
    }

    /**
     * Get Birthday 
     * @return DateOfBirth Birthday
     */
    public String getDateOfBirth() {
        return this.DateOfBirth;
    }

    /**
     * Set Birthday
     * @param DateOfBirth Birthday
     */
    public void setDateOfBirth(String DateOfBirth) {
        this.DateOfBirth = DateOfBirth;
    }

    /**
     * Get Gender 
     * @return Sex Gender
     */
    public String getSex() {
        return this.Sex;
    }

    /**
     * Set Gender
     * @param Sex Gender
     */
    public void setSex(String Sex) {
        this.Sex = Sex;
    }

    /**
     * Get Date of entry 
     * @return EntryDate Date of entry
     */
    public String getEntryDate() {
        return this.EntryDate;
    }

    /**
     * Set Date of entry
     * @param EntryDate Date of entry
     */
    public void setEntryDate(String EntryDate) {
        this.EntryDate = EntryDate;
    }

    /**
     * Get VIA 
     * @return VIA VIA
     */
    public String getVIA() {
        return this.VIA;
    }

    /**
     * Set VIA
     * @param VIA VIA
     */
    public void setVIA(String VIA) {
        this.VIA = VIA;
    }

    /**
     * Get Dispatch date 
     * @return DispatchDate Dispatch date
     */
    public String getDispatchDate() {
        return this.DispatchDate;
    }

    /**
     * Set Dispatch date
     * @param DispatchDate Dispatch date
     */
    public void setDispatchDate(String DispatchDate) {
        this.DispatchDate = DispatchDate;
    }

    /**
     * Get MRZ 
     * @return MRZ MRZ
     */
    public String getMRZ() {
        return this.MRZ;
    }

    /**
     * Set MRZ
     * @param MRZ MRZ
     */
    public void setMRZ(String MRZ) {
        this.MRZ = MRZ;
    }

    /**
     * Get PortraitImage base64 
     * @return PortraitImage PortraitImage base64
     */
    public String getPortraitImage() {
        return this.PortraitImage;
    }

    /**
     * Set PortraitImage base64
     * @param PortraitImage PortraitImage base64
     */
    public void setPortraitImage(String PortraitImage) {
        this.PortraitImage = PortraitImage;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecognizeBrazilRNEOCRResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecognizeBrazilRNEOCRResponse(RecognizeBrazilRNEOCRResponse source) {
        if (source.RNE != null) {
            this.RNE = new String(source.RNE);
        }
        if (source.CLASSIFICATION != null) {
            this.CLASSIFICATION = new String(source.CLASSIFICATION);
        }
        if (source.VALIDADE != null) {
            this.VALIDADE = new String(source.VALIDADE);
        }
        if (source.NOME != null) {
            this.NOME = new String(source.NOME);
        }
        if (source.Membership != null) {
            this.Membership = new String(source.Membership);
        }
        if (source.NACIONALIDADE != null) {
            this.NACIONALIDADE = new String(source.NACIONALIDADE);
        }
        if (source.NATURALIDADE != null) {
            this.NATURALIDADE = new String(source.NATURALIDADE);
        }
        if (source.IssuingAgency != null) {
            this.IssuingAgency = new String(source.IssuingAgency);
        }
        if (source.DateOfBirth != null) {
            this.DateOfBirth = new String(source.DateOfBirth);
        }
        if (source.Sex != null) {
            this.Sex = new String(source.Sex);
        }
        if (source.EntryDate != null) {
            this.EntryDate = new String(source.EntryDate);
        }
        if (source.VIA != null) {
            this.VIA = new String(source.VIA);
        }
        if (source.DispatchDate != null) {
            this.DispatchDate = new String(source.DispatchDate);
        }
        if (source.MRZ != null) {
            this.MRZ = new String(source.MRZ);
        }
        if (source.PortraitImage != null) {
            this.PortraitImage = new String(source.PortraitImage);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "RNE", this.RNE);
        this.setParamSimple(map, prefix + "CLASSIFICATION", this.CLASSIFICATION);
        this.setParamSimple(map, prefix + "VALIDADE", this.VALIDADE);
        this.setParamSimple(map, prefix + "NOME", this.NOME);
        this.setParamSimple(map, prefix + "Membership", this.Membership);
        this.setParamSimple(map, prefix + "NACIONALIDADE", this.NACIONALIDADE);
        this.setParamSimple(map, prefix + "NATURALIDADE", this.NATURALIDADE);
        this.setParamSimple(map, prefix + "IssuingAgency", this.IssuingAgency);
        this.setParamSimple(map, prefix + "DateOfBirth", this.DateOfBirth);
        this.setParamSimple(map, prefix + "Sex", this.Sex);
        this.setParamSimple(map, prefix + "EntryDate", this.EntryDate);
        this.setParamSimple(map, prefix + "VIA", this.VIA);
        this.setParamSimple(map, prefix + "DispatchDate", this.DispatchDate);
        this.setParamSimple(map, prefix + "MRZ", this.MRZ);
        this.setParamSimple(map, prefix + "PortraitImage", this.PortraitImage);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

