/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecognizeBrazilRNMOCRResponse extends AbstractModel {

    /**
    * Last name
    */
    @SerializedName("SOBRENOME")
    @Expose
    private String SOBRENOME;

    /**
    * First name
    */
    @SerializedName("NOME")
    @Expose
    private String NOME;

    /**
    * Date of Birth
    */
    @SerializedName("DATADENASCIMENTO")
    @Expose
    private String DATADENASCIMENTO;

    /**
    * Gender
    */
    @SerializedName("SEXO")
    @Expose
    private String SEXO;

    /**
    * Parents name
    */
    @SerializedName("MEMBERSHIP")
    @Expose
    private String MEMBERSHIP;

    /**
    * Nationality
    */
    @SerializedName("NACIONALIDADE")
    @Expose
    private String NACIONALIDADE;

    /**
    * Expiry Date
    */
    @SerializedName("VALIDADE")
    @Expose
    private String VALIDADE;

    /**
    * RNM
    */
    @SerializedName("RNM")
    @Expose
    private String RNM;

    /**
    * CPF
    */
    @SerializedName("CPF")
    @Expose
    private String CPF;

    /**
    * 
    */
    @SerializedName("CLASSIFICATION")
    @Expose
    private String CLASSIFICATION;

    /**
    * 
    */
    @SerializedName("PRAZODERESIDENCIA")
    @Expose
    private String PRAZODERESIDENCIA;

    /**
    * Issue Date
    */
    @SerializedName("ISSUANCE")
    @Expose
    private String ISSUANCE;

    /**
    * Legal basis
    */
    @SerializedName("AMPAROLEGAL")
    @Expose
    private String AMPAROLEGAL;

    /**
    * Machine readable zone code
    */
    @SerializedName("MRZ")
    @Expose
    private String MRZ;

    /**
    * PortraitImage
    */
    @SerializedName("PortraitImage")
    @Expose
    private String PortraitImage;

    /**
    * PortraitImage(Back)
    */
    @SerializedName("PortraitImageBack")
    @Expose
    private String PortraitImageBack;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Last name 
     * @return SOBRENOME Last name
     */
    public String getSOBRENOME() {
        return this.SOBRENOME;
    }

    /**
     * Set Last name
     * @param SOBRENOME Last name
     */
    public void setSOBRENOME(String SOBRENOME) {
        this.SOBRENOME = SOBRENOME;
    }

    /**
     * Get First name 
     * @return NOME First name
     */
    public String getNOME() {
        return this.NOME;
    }

    /**
     * Set First name
     * @param NOME First name
     */
    public void setNOME(String NOME) {
        this.NOME = NOME;
    }

    /**
     * Get Date of Birth 
     * @return DATADENASCIMENTO Date of Birth
     */
    public String getDATADENASCIMENTO() {
        return this.DATADENASCIMENTO;
    }

    /**
     * Set Date of Birth
     * @param DATADENASCIMENTO Date of Birth
     */
    public void setDATADENASCIMENTO(String DATADENASCIMENTO) {
        this.DATADENASCIMENTO = DATADENASCIMENTO;
    }

    /**
     * Get Gender 
     * @return SEXO Gender
     */
    public String getSEXO() {
        return this.SEXO;
    }

    /**
     * Set Gender
     * @param SEXO Gender
     */
    public void setSEXO(String SEXO) {
        this.SEXO = SEXO;
    }

    /**
     * Get Parents name 
     * @return MEMBERSHIP Parents name
     */
    public String getMEMBERSHIP() {
        return this.MEMBERSHIP;
    }

    /**
     * Set Parents name
     * @param MEMBERSHIP Parents name
     */
    public void setMEMBERSHIP(String MEMBERSHIP) {
        this.MEMBERSHIP = MEMBERSHIP;
    }

    /**
     * Get Nationality 
     * @return NACIONALIDADE Nationality
     */
    public String getNACIONALIDADE() {
        return this.NACIONALIDADE;
    }

    /**
     * Set Nationality
     * @param NACIONALIDADE Nationality
     */
    public void setNACIONALIDADE(String NACIONALIDADE) {
        this.NACIONALIDADE = NACIONALIDADE;
    }

    /**
     * Get Expiry Date 
     * @return VALIDADE Expiry Date
     */
    public String getVALIDADE() {
        return this.VALIDADE;
    }

    /**
     * Set Expiry Date
     * @param VALIDADE Expiry Date
     */
    public void setVALIDADE(String VALIDADE) {
        this.VALIDADE = VALIDADE;
    }

    /**
     * Get RNM 
     * @return RNM RNM
     */
    public String getRNM() {
        return this.RNM;
    }

    /**
     * Set RNM
     * @param RNM RNM
     */
    public void setRNM(String RNM) {
        this.RNM = RNM;
    }

    /**
     * Get CPF 
     * @return CPF CPF
     */
    public String getCPF() {
        return this.CPF;
    }

    /**
     * Set CPF
     * @param CPF CPF
     */
    public void setCPF(String CPF) {
        this.CPF = CPF;
    }

    /**
     * Get  
     * @return CLASSIFICATION 
     */
    public String getCLASSIFICATION() {
        return this.CLASSIFICATION;
    }

    /**
     * Set 
     * @param CLASSIFICATION 
     */
    public void setCLASSIFICATION(String CLASSIFICATION) {
        this.CLASSIFICATION = CLASSIFICATION;
    }

    /**
     * Get  
     * @return PRAZODERESIDENCIA 
     */
    public String getPRAZODERESIDENCIA() {
        return this.PRAZODERESIDENCIA;
    }

    /**
     * Set 
     * @param PRAZODERESIDENCIA 
     */
    public void setPRAZODERESIDENCIA(String PRAZODERESIDENCIA) {
        this.PRAZODERESIDENCIA = PRAZODERESIDENCIA;
    }

    /**
     * Get Issue Date 
     * @return ISSUANCE Issue Date
     */
    public String getISSUANCE() {
        return this.ISSUANCE;
    }

    /**
     * Set Issue Date
     * @param ISSUANCE Issue Date
     */
    public void setISSUANCE(String ISSUANCE) {
        this.ISSUANCE = ISSUANCE;
    }

    /**
     * Get Legal basis 
     * @return AMPAROLEGAL Legal basis
     */
    public String getAMPAROLEGAL() {
        return this.AMPAROLEGAL;
    }

    /**
     * Set Legal basis
     * @param AMPAROLEGAL Legal basis
     */
    public void setAMPAROLEGAL(String AMPAROLEGAL) {
        this.AMPAROLEGAL = AMPAROLEGAL;
    }

    /**
     * Get Machine readable zone code 
     * @return MRZ Machine readable zone code
     */
    public String getMRZ() {
        return this.MRZ;
    }

    /**
     * Set Machine readable zone code
     * @param MRZ Machine readable zone code
     */
    public void setMRZ(String MRZ) {
        this.MRZ = MRZ;
    }

    /**
     * Get PortraitImage 
     * @return PortraitImage PortraitImage
     */
    public String getPortraitImage() {
        return this.PortraitImage;
    }

    /**
     * Set PortraitImage
     * @param PortraitImage PortraitImage
     */
    public void setPortraitImage(String PortraitImage) {
        this.PortraitImage = PortraitImage;
    }

    /**
     * Get PortraitImage(Back) 
     * @return PortraitImageBack PortraitImage(Back)
     */
    public String getPortraitImageBack() {
        return this.PortraitImageBack;
    }

    /**
     * Set PortraitImage(Back)
     * @param PortraitImageBack PortraitImage(Back)
     */
    public void setPortraitImageBack(String PortraitImageBack) {
        this.PortraitImageBack = PortraitImageBack;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecognizeBrazilRNMOCRResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecognizeBrazilRNMOCRResponse(RecognizeBrazilRNMOCRResponse source) {
        if (source.SOBRENOME != null) {
            this.SOBRENOME = new String(source.SOBRENOME);
        }
        if (source.NOME != null) {
            this.NOME = new String(source.NOME);
        }
        if (source.DATADENASCIMENTO != null) {
            this.DATADENASCIMENTO = new String(source.DATADENASCIMENTO);
        }
        if (source.SEXO != null) {
            this.SEXO = new String(source.SEXO);
        }
        if (source.MEMBERSHIP != null) {
            this.MEMBERSHIP = new String(source.MEMBERSHIP);
        }
        if (source.NACIONALIDADE != null) {
            this.NACIONALIDADE = new String(source.NACIONALIDADE);
        }
        if (source.VALIDADE != null) {
            this.VALIDADE = new String(source.VALIDADE);
        }
        if (source.RNM != null) {
            this.RNM = new String(source.RNM);
        }
        if (source.CPF != null) {
            this.CPF = new String(source.CPF);
        }
        if (source.CLASSIFICATION != null) {
            this.CLASSIFICATION = new String(source.CLASSIFICATION);
        }
        if (source.PRAZODERESIDENCIA != null) {
            this.PRAZODERESIDENCIA = new String(source.PRAZODERESIDENCIA);
        }
        if (source.ISSUANCE != null) {
            this.ISSUANCE = new String(source.ISSUANCE);
        }
        if (source.AMPAROLEGAL != null) {
            this.AMPAROLEGAL = new String(source.AMPAROLEGAL);
        }
        if (source.MRZ != null) {
            this.MRZ = new String(source.MRZ);
        }
        if (source.PortraitImage != null) {
            this.PortraitImage = new String(source.PortraitImage);
        }
        if (source.PortraitImageBack != null) {
            this.PortraitImageBack = new String(source.PortraitImageBack);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "SOBRENOME", this.SOBRENOME);
        this.setParamSimple(map, prefix + "NOME", this.NOME);
        this.setParamSimple(map, prefix + "DATADENASCIMENTO", this.DATADENASCIMENTO);
        this.setParamSimple(map, prefix + "SEXO", this.SEXO);
        this.setParamSimple(map, prefix + "MEMBERSHIP", this.MEMBERSHIP);
        this.setParamSimple(map, prefix + "NACIONALIDADE", this.NACIONALIDADE);
        this.setParamSimple(map, prefix + "VALIDADE", this.VALIDADE);
        this.setParamSimple(map, prefix + "RNM", this.RNM);
        this.setParamSimple(map, prefix + "CPF", this.CPF);
        this.setParamSimple(map, prefix + "CLASSIFICATION", this.CLASSIFICATION);
        this.setParamSimple(map, prefix + "PRAZODERESIDENCIA", this.PRAZODERESIDENCIA);
        this.setParamSimple(map, prefix + "ISSUANCE", this.ISSUANCE);
        this.setParamSimple(map, prefix + "AMPAROLEGAL", this.AMPAROLEGAL);
        this.setParamSimple(map, prefix + "MRZ", this.MRZ);
        this.setParamSimple(map, prefix + "PortraitImage", this.PortraitImage);
        this.setParamSimple(map, prefix + "PortraitImageBack", this.PortraitImageBack);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

