/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecognizeMacaoIDCardOCRResponse extends AbstractModel {

    /**
    * Chinese last name
    */
    @SerializedName("CnLastName")
    @Expose
    private String CnLastName;

    /**
    * English last name
    */
    @SerializedName("EnLastName")
    @Expose
    private String EnLastName;

    /**
    * Last name code
    */
    @SerializedName("LastNameCode")
    @Expose
    private String LastNameCode;

    /**
    * Chinese first name
    */
    @SerializedName("CnFirstName")
    @Expose
    private String CnFirstName;

    /**
    * English first name
    */
    @SerializedName("EnFirstName")
    @Expose
    private String EnFirstName;

    /**
    * First name code
    */
    @SerializedName("FirstNameCode")
    @Expose
    private String FirstNameCode;

    /**
    * ID Number
    */
    @SerializedName("ID")
    @Expose
    private String ID;

    /**
    * Birthday(DD-MM-YYYY)
    */
    @SerializedName("Birthday")
    @Expose
    private String Birthday;

    /**
    * gender
    */
    @SerializedName("Sex")
    @Expose
    private String Sex;

    /**
    * First issue Date (DD-MM-YYYY)
    */
    @SerializedName("FirstIssueDate")
    @Expose
    private String FirstIssueDate;

    /**
    * Issue date (DD-MM-YYYY)
    */
    @SerializedName("CurrentIssueDate")
    @Expose
    private String CurrentIssueDate;

    /**
    * Validity period (DD-MM-YYYY)
    */
    @SerializedName("ValidityPeriod")
    @Expose
    private String ValidityPeriod;

    /**
    * ID symbol
    */
    @SerializedName("Symbol")
    @Expose
    private String Symbol;

    /**
    * Height (unit: meters)
    */
    @SerializedName("Height")
    @Expose
    private String Height;

    /**
    * Processed image (Base64)
    */
    @SerializedName("RetImage")
    @Expose
    private String RetImage;

    /**
    * Image rotation angle, the horizontal direction of the text is 0, clockwise is positive, counterclockwise is negative
    */
    @SerializedName("Angle")
    @Expose
    private String Angle;

    /**
    * Resident type.
    */
    @SerializedName("ResidentType")
    @Expose
    private String ResidentType;

    /**
    * Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
    */
    @SerializedName("WarnCardInfos")
    @Expose
    private Long [] WarnCardInfos;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Chinese last name 
     * @return CnLastName Chinese last name
     */
    public String getCnLastName() {
        return this.CnLastName;
    }

    /**
     * Set Chinese last name
     * @param CnLastName Chinese last name
     */
    public void setCnLastName(String CnLastName) {
        this.CnLastName = CnLastName;
    }

    /**
     * Get English last name 
     * @return EnLastName English last name
     */
    public String getEnLastName() {
        return this.EnLastName;
    }

    /**
     * Set English last name
     * @param EnLastName English last name
     */
    public void setEnLastName(String EnLastName) {
        this.EnLastName = EnLastName;
    }

    /**
     * Get Last name code 
     * @return LastNameCode Last name code
     */
    public String getLastNameCode() {
        return this.LastNameCode;
    }

    /**
     * Set Last name code
     * @param LastNameCode Last name code
     */
    public void setLastNameCode(String LastNameCode) {
        this.LastNameCode = LastNameCode;
    }

    /**
     * Get Chinese first name 
     * @return CnFirstName Chinese first name
     */
    public String getCnFirstName() {
        return this.CnFirstName;
    }

    /**
     * Set Chinese first name
     * @param CnFirstName Chinese first name
     */
    public void setCnFirstName(String CnFirstName) {
        this.CnFirstName = CnFirstName;
    }

    /**
     * Get English first name 
     * @return EnFirstName English first name
     */
    public String getEnFirstName() {
        return this.EnFirstName;
    }

    /**
     * Set English first name
     * @param EnFirstName English first name
     */
    public void setEnFirstName(String EnFirstName) {
        this.EnFirstName = EnFirstName;
    }

    /**
     * Get First name code 
     * @return FirstNameCode First name code
     */
    public String getFirstNameCode() {
        return this.FirstNameCode;
    }

    /**
     * Set First name code
     * @param FirstNameCode First name code
     */
    public void setFirstNameCode(String FirstNameCode) {
        this.FirstNameCode = FirstNameCode;
    }

    /**
     * Get ID Number 
     * @return ID ID Number
     */
    public String getID() {
        return this.ID;
    }

    /**
     * Set ID Number
     * @param ID ID Number
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /**
     * Get Birthday(DD-MM-YYYY) 
     * @return Birthday Birthday(DD-MM-YYYY)
     */
    public String getBirthday() {
        return this.Birthday;
    }

    /**
     * Set Birthday(DD-MM-YYYY)
     * @param Birthday Birthday(DD-MM-YYYY)
     */
    public void setBirthday(String Birthday) {
        this.Birthday = Birthday;
    }

    /**
     * Get gender 
     * @return Sex gender
     */
    public String getSex() {
        return this.Sex;
    }

    /**
     * Set gender
     * @param Sex gender
     */
    public void setSex(String Sex) {
        this.Sex = Sex;
    }

    /**
     * Get First issue Date (DD-MM-YYYY) 
     * @return FirstIssueDate First issue Date (DD-MM-YYYY)
     */
    public String getFirstIssueDate() {
        return this.FirstIssueDate;
    }

    /**
     * Set First issue Date (DD-MM-YYYY)
     * @param FirstIssueDate First issue Date (DD-MM-YYYY)
     */
    public void setFirstIssueDate(String FirstIssueDate) {
        this.FirstIssueDate = FirstIssueDate;
    }

    /**
     * Get Issue date (DD-MM-YYYY) 
     * @return CurrentIssueDate Issue date (DD-MM-YYYY)
     */
    public String getCurrentIssueDate() {
        return this.CurrentIssueDate;
    }

    /**
     * Set Issue date (DD-MM-YYYY)
     * @param CurrentIssueDate Issue date (DD-MM-YYYY)
     */
    public void setCurrentIssueDate(String CurrentIssueDate) {
        this.CurrentIssueDate = CurrentIssueDate;
    }

    /**
     * Get Validity period (DD-MM-YYYY) 
     * @return ValidityPeriod Validity period (DD-MM-YYYY)
     */
    public String getValidityPeriod() {
        return this.ValidityPeriod;
    }

    /**
     * Set Validity period (DD-MM-YYYY)
     * @param ValidityPeriod Validity period (DD-MM-YYYY)
     */
    public void setValidityPeriod(String ValidityPeriod) {
        this.ValidityPeriod = ValidityPeriod;
    }

    /**
     * Get ID symbol 
     * @return Symbol ID symbol
     */
    public String getSymbol() {
        return this.Symbol;
    }

    /**
     * Set ID symbol
     * @param Symbol ID symbol
     */
    public void setSymbol(String Symbol) {
        this.Symbol = Symbol;
    }

    /**
     * Get Height (unit: meters) 
     * @return Height Height (unit: meters)
     */
    public String getHeight() {
        return this.Height;
    }

    /**
     * Set Height (unit: meters)
     * @param Height Height (unit: meters)
     */
    public void setHeight(String Height) {
        this.Height = Height;
    }

    /**
     * Get Processed image (Base64) 
     * @return RetImage Processed image (Base64)
     */
    public String getRetImage() {
        return this.RetImage;
    }

    /**
     * Set Processed image (Base64)
     * @param RetImage Processed image (Base64)
     */
    public void setRetImage(String RetImage) {
        this.RetImage = RetImage;
    }

    /**
     * Get Image rotation angle, the horizontal direction of the text is 0, clockwise is positive, counterclockwise is negative 
     * @return Angle Image rotation angle, the horizontal direction of the text is 0, clockwise is positive, counterclockwise is negative
     */
    public String getAngle() {
        return this.Angle;
    }

    /**
     * Set Image rotation angle, the horizontal direction of the text is 0, clockwise is positive, counterclockwise is negative
     * @param Angle Image rotation angle, the horizontal direction of the text is 0, clockwise is positive, counterclockwise is negative
     */
    public void setAngle(String Angle) {
        this.Angle = Angle;
    }

    /**
     * Get Resident type. 
     * @return ResidentType Resident type.
     */
    public String getResidentType() {
        return this.ResidentType;
    }

    /**
     * Set Resident type.
     * @param ResidentType Resident type.
     */
    public void setResidentType(String ResidentType) {
        this.ResidentType = ResidentType;
    }

    /**
     * Get Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled. 
     * @return WarnCardInfos Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     */
    public Long [] getWarnCardInfos() {
        return this.WarnCardInfos;
    }

    /**
     * Set Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     * @param WarnCardInfos Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     */
    public void setWarnCardInfos(Long [] WarnCardInfos) {
        this.WarnCardInfos = WarnCardInfos;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecognizeMacaoIDCardOCRResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecognizeMacaoIDCardOCRResponse(RecognizeMacaoIDCardOCRResponse source) {
        if (source.CnLastName != null) {
            this.CnLastName = new String(source.CnLastName);
        }
        if (source.EnLastName != null) {
            this.EnLastName = new String(source.EnLastName);
        }
        if (source.LastNameCode != null) {
            this.LastNameCode = new String(source.LastNameCode);
        }
        if (source.CnFirstName != null) {
            this.CnFirstName = new String(source.CnFirstName);
        }
        if (source.EnFirstName != null) {
            this.EnFirstName = new String(source.EnFirstName);
        }
        if (source.FirstNameCode != null) {
            this.FirstNameCode = new String(source.FirstNameCode);
        }
        if (source.ID != null) {
            this.ID = new String(source.ID);
        }
        if (source.Birthday != null) {
            this.Birthday = new String(source.Birthday);
        }
        if (source.Sex != null) {
            this.Sex = new String(source.Sex);
        }
        if (source.FirstIssueDate != null) {
            this.FirstIssueDate = new String(source.FirstIssueDate);
        }
        if (source.CurrentIssueDate != null) {
            this.CurrentIssueDate = new String(source.CurrentIssueDate);
        }
        if (source.ValidityPeriod != null) {
            this.ValidityPeriod = new String(source.ValidityPeriod);
        }
        if (source.Symbol != null) {
            this.Symbol = new String(source.Symbol);
        }
        if (source.Height != null) {
            this.Height = new String(source.Height);
        }
        if (source.RetImage != null) {
            this.RetImage = new String(source.RetImage);
        }
        if (source.Angle != null) {
            this.Angle = new String(source.Angle);
        }
        if (source.ResidentType != null) {
            this.ResidentType = new String(source.ResidentType);
        }
        if (source.WarnCardInfos != null) {
            this.WarnCardInfos = new Long[source.WarnCardInfos.length];
            for (int i = 0; i < source.WarnCardInfos.length; i++) {
                this.WarnCardInfos[i] = new Long(source.WarnCardInfos[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CnLastName", this.CnLastName);
        this.setParamSimple(map, prefix + "EnLastName", this.EnLastName);
        this.setParamSimple(map, prefix + "LastNameCode", this.LastNameCode);
        this.setParamSimple(map, prefix + "CnFirstName", this.CnFirstName);
        this.setParamSimple(map, prefix + "EnFirstName", this.EnFirstName);
        this.setParamSimple(map, prefix + "FirstNameCode", this.FirstNameCode);
        this.setParamSimple(map, prefix + "ID", this.ID);
        this.setParamSimple(map, prefix + "Birthday", this.Birthday);
        this.setParamSimple(map, prefix + "Sex", this.Sex);
        this.setParamSimple(map, prefix + "FirstIssueDate", this.FirstIssueDate);
        this.setParamSimple(map, prefix + "CurrentIssueDate", this.CurrentIssueDate);
        this.setParamSimple(map, prefix + "ValidityPeriod", this.ValidityPeriod);
        this.setParamSimple(map, prefix + "Symbol", this.Symbol);
        this.setParamSimple(map, prefix + "Height", this.Height);
        this.setParamSimple(map, prefix + "RetImage", this.RetImage);
        this.setParamSimple(map, prefix + "Angle", this.Angle);
        this.setParamSimple(map, prefix + "ResidentType", this.ResidentType);
        this.setParamArraySimple(map, prefix + "WarnCardInfos.", this.WarnCardInfos);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

