/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecognizeMexicoVTIDResponse extends AbstractModel {

    /**
    * Name
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Sex
    */
    @SerializedName("Sex")
    @Expose
    private String Sex;

    /**
    * Address
    */
    @SerializedName("Address")
    @Expose
    private String Address;

    /**
    * Vote PIN Code
    */
    @SerializedName("VotePIN")
    @Expose
    private String VotePIN;

    /**
    * Unique Population Registry Code
    */
    @SerializedName("CURP")
    @Expose
    private String CURP;

    /**
    * Birthday
    */
    @SerializedName("Birth")
    @Expose
    private String Birth;

    /**
    * Section Number
    */
    @SerializedName("SECCION")
    @Expose
    private String SECCION;

    /**
    * IssueDate
    */
    @SerializedName("IssueDate")
    @Expose
    private String IssueDate;

    /**
    * ValidDate
    */
    @SerializedName("ValidDate")
    @Expose
    private String ValidDate;

    /**
    * State
    */
    @SerializedName("State")
    @Expose
    private String State;

    /**
    * City
    */
    @SerializedName("City")
    @Expose
    private String City;

    /**
    * Locality
    */
    @SerializedName("Locality")
    @Expose
    private String Locality;

    /**
    * Edition
    */
    @SerializedName("EMISION")
    @Expose
    private String EMISION;

    /**
    * Portrait image base64
    */
    @SerializedName("PortraitImage")
    @Expose
    private String PortraitImage;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Name 
     * @return Name Name
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Name
     * @param Name Name
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Sex 
     * @return Sex Sex
     */
    public String getSex() {
        return this.Sex;
    }

    /**
     * Set Sex
     * @param Sex Sex
     */
    public void setSex(String Sex) {
        this.Sex = Sex;
    }

    /**
     * Get Address 
     * @return Address Address
     */
    public String getAddress() {
        return this.Address;
    }

    /**
     * Set Address
     * @param Address Address
     */
    public void setAddress(String Address) {
        this.Address = Address;
    }

    /**
     * Get Vote PIN Code 
     * @return VotePIN Vote PIN Code
     */
    public String getVotePIN() {
        return this.VotePIN;
    }

    /**
     * Set Vote PIN Code
     * @param VotePIN Vote PIN Code
     */
    public void setVotePIN(String VotePIN) {
        this.VotePIN = VotePIN;
    }

    /**
     * Get Unique Population Registry Code 
     * @return CURP Unique Population Registry Code
     */
    public String getCURP() {
        return this.CURP;
    }

    /**
     * Set Unique Population Registry Code
     * @param CURP Unique Population Registry Code
     */
    public void setCURP(String CURP) {
        this.CURP = CURP;
    }

    /**
     * Get Birthday 
     * @return Birth Birthday
     */
    public String getBirth() {
        return this.Birth;
    }

    /**
     * Set Birthday
     * @param Birth Birthday
     */
    public void setBirth(String Birth) {
        this.Birth = Birth;
    }

    /**
     * Get Section Number 
     * @return SECCION Section Number
     */
    public String getSECCION() {
        return this.SECCION;
    }

    /**
     * Set Section Number
     * @param SECCION Section Number
     */
    public void setSECCION(String SECCION) {
        this.SECCION = SECCION;
    }

    /**
     * Get IssueDate 
     * @return IssueDate IssueDate
     */
    public String getIssueDate() {
        return this.IssueDate;
    }

    /**
     * Set IssueDate
     * @param IssueDate IssueDate
     */
    public void setIssueDate(String IssueDate) {
        this.IssueDate = IssueDate;
    }

    /**
     * Get ValidDate 
     * @return ValidDate ValidDate
     */
    public String getValidDate() {
        return this.ValidDate;
    }

    /**
     * Set ValidDate
     * @param ValidDate ValidDate
     */
    public void setValidDate(String ValidDate) {
        this.ValidDate = ValidDate;
    }

    /**
     * Get State 
     * @return State State
     */
    public String getState() {
        return this.State;
    }

    /**
     * Set State
     * @param State State
     */
    public void setState(String State) {
        this.State = State;
    }

    /**
     * Get City 
     * @return City City
     */
    public String getCity() {
        return this.City;
    }

    /**
     * Set City
     * @param City City
     */
    public void setCity(String City) {
        this.City = City;
    }

    /**
     * Get Locality 
     * @return Locality Locality
     */
    public String getLocality() {
        return this.Locality;
    }

    /**
     * Set Locality
     * @param Locality Locality
     */
    public void setLocality(String Locality) {
        this.Locality = Locality;
    }

    /**
     * Get Edition 
     * @return EMISION Edition
     */
    public String getEMISION() {
        return this.EMISION;
    }

    /**
     * Set Edition
     * @param EMISION Edition
     */
    public void setEMISION(String EMISION) {
        this.EMISION = EMISION;
    }

    /**
     * Get Portrait image base64 
     * @return PortraitImage Portrait image base64
     */
    public String getPortraitImage() {
        return this.PortraitImage;
    }

    /**
     * Set Portrait image base64
     * @param PortraitImage Portrait image base64
     */
    public void setPortraitImage(String PortraitImage) {
        this.PortraitImage = PortraitImage;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecognizeMexicoVTIDResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecognizeMexicoVTIDResponse(RecognizeMexicoVTIDResponse source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Sex != null) {
            this.Sex = new String(source.Sex);
        }
        if (source.Address != null) {
            this.Address = new String(source.Address);
        }
        if (source.VotePIN != null) {
            this.VotePIN = new String(source.VotePIN);
        }
        if (source.CURP != null) {
            this.CURP = new String(source.CURP);
        }
        if (source.Birth != null) {
            this.Birth = new String(source.Birth);
        }
        if (source.SECCION != null) {
            this.SECCION = new String(source.SECCION);
        }
        if (source.IssueDate != null) {
            this.IssueDate = new String(source.IssueDate);
        }
        if (source.ValidDate != null) {
            this.ValidDate = new String(source.ValidDate);
        }
        if (source.State != null) {
            this.State = new String(source.State);
        }
        if (source.City != null) {
            this.City = new String(source.City);
        }
        if (source.Locality != null) {
            this.Locality = new String(source.Locality);
        }
        if (source.EMISION != null) {
            this.EMISION = new String(source.EMISION);
        }
        if (source.PortraitImage != null) {
            this.PortraitImage = new String(source.PortraitImage);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Sex", this.Sex);
        this.setParamSimple(map, prefix + "Address", this.Address);
        this.setParamSimple(map, prefix + "VotePIN", this.VotePIN);
        this.setParamSimple(map, prefix + "CURP", this.CURP);
        this.setParamSimple(map, prefix + "Birth", this.Birth);
        this.setParamSimple(map, prefix + "SECCION", this.SECCION);
        this.setParamSimple(map, prefix + "IssueDate", this.IssueDate);
        this.setParamSimple(map, prefix + "ValidDate", this.ValidDate);
        this.setParamSimple(map, prefix + "State", this.State);
        this.setParamSimple(map, prefix + "City", this.City);
        this.setParamSimple(map, prefix + "Locality", this.Locality);
        this.setParamSimple(map, prefix + "EMISION", this.EMISION);
        this.setParamSimple(map, prefix + "PortraitImage", this.PortraitImage);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

