/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ocr.v20181119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecognizeThaiIDCardOCRResponse extends AbstractModel {

    /**
    * ID card number
    */
    @SerializedName("ID")
    @Expose
    private String ID;

    /**
    * Name in Thai
    */
    @SerializedName("ThaiName")
    @Expose
    private String ThaiName;

    /**
    * Name in English
    */
    @SerializedName("EnFirstName")
    @Expose
    private String EnFirstName;

    /**
    * Name in English
    */
    @SerializedName("EnLastName")
    @Expose
    private String EnLastName;

    /**
    * Date of issue in Thai
    */
    @SerializedName("IssueDate")
    @Expose
    private String IssueDate;

    /**
    * Expiration date in Thai
    */
    @SerializedName("ExpirationDate")
    @Expose
    private String ExpirationDate;

    /**
    * Date of issue in English
    */
    @SerializedName("EnIssueDate")
    @Expose
    private String EnIssueDate;

    /**
    * Expiration date in English
    */
    @SerializedName("EnExpirationDate")
    @Expose
    private String EnExpirationDate;

    /**
    * Date of birth in Thai
    */
    @SerializedName("Birthday")
    @Expose
    private String Birthday;

    /**
    * Date of birth in English
    */
    @SerializedName("EnBirthday")
    @Expose
    private String EnBirthday;

    /**
    * Religion
    */
    @SerializedName("Religion")
    @Expose
    private String Religion;

    /**
    * Serial number
    */
    @SerializedName("SerialNumber")
    @Expose
    private String SerialNumber;

    /**
    * Address
    */
    @SerializedName("Address")
    @Expose
    private String Address;

    /**
    * LaserID in the back of the card.
    */
    @SerializedName("LaserID")
    @Expose
    private String LaserID;

    /**
    * Identity photo
    */
    @SerializedName("PortraitImage")
    @Expose
    private String PortraitImage;

    /**
    * Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
    */
    @SerializedName("WarnCardInfos")
    @Expose
    private Long [] WarnCardInfos;

    /**
    * This field is deprecated and will always return "1". Usage is not recommended.
    */
    @SerializedName("AdvancedInfo")
    @Expose
    private String AdvancedInfo;

    /**
    * The number of cards detected in the input image provided via ImageBase64 parameter.(Currently supported only in ap-bangkok region)
    */
    @SerializedName("CardCount")
    @Expose
    private Long CardCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get ID card number 
     * @return ID ID card number
     */
    public String getID() {
        return this.ID;
    }

    /**
     * Set ID card number
     * @param ID ID card number
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /**
     * Get Name in Thai 
     * @return ThaiName Name in Thai
     */
    public String getThaiName() {
        return this.ThaiName;
    }

    /**
     * Set Name in Thai
     * @param ThaiName Name in Thai
     */
    public void setThaiName(String ThaiName) {
        this.ThaiName = ThaiName;
    }

    /**
     * Get Name in English 
     * @return EnFirstName Name in English
     */
    public String getEnFirstName() {
        return this.EnFirstName;
    }

    /**
     * Set Name in English
     * @param EnFirstName Name in English
     */
    public void setEnFirstName(String EnFirstName) {
        this.EnFirstName = EnFirstName;
    }

    /**
     * Get Name in English 
     * @return EnLastName Name in English
     */
    public String getEnLastName() {
        return this.EnLastName;
    }

    /**
     * Set Name in English
     * @param EnLastName Name in English
     */
    public void setEnLastName(String EnLastName) {
        this.EnLastName = EnLastName;
    }

    /**
     * Get Date of issue in Thai 
     * @return IssueDate Date of issue in Thai
     */
    public String getIssueDate() {
        return this.IssueDate;
    }

    /**
     * Set Date of issue in Thai
     * @param IssueDate Date of issue in Thai
     */
    public void setIssueDate(String IssueDate) {
        this.IssueDate = IssueDate;
    }

    /**
     * Get Expiration date in Thai 
     * @return ExpirationDate Expiration date in Thai
     */
    public String getExpirationDate() {
        return this.ExpirationDate;
    }

    /**
     * Set Expiration date in Thai
     * @param ExpirationDate Expiration date in Thai
     */
    public void setExpirationDate(String ExpirationDate) {
        this.ExpirationDate = ExpirationDate;
    }

    /**
     * Get Date of issue in English 
     * @return EnIssueDate Date of issue in English
     */
    public String getEnIssueDate() {
        return this.EnIssueDate;
    }

    /**
     * Set Date of issue in English
     * @param EnIssueDate Date of issue in English
     */
    public void setEnIssueDate(String EnIssueDate) {
        this.EnIssueDate = EnIssueDate;
    }

    /**
     * Get Expiration date in English 
     * @return EnExpirationDate Expiration date in English
     */
    public String getEnExpirationDate() {
        return this.EnExpirationDate;
    }

    /**
     * Set Expiration date in English
     * @param EnExpirationDate Expiration date in English
     */
    public void setEnExpirationDate(String EnExpirationDate) {
        this.EnExpirationDate = EnExpirationDate;
    }

    /**
     * Get Date of birth in Thai 
     * @return Birthday Date of birth in Thai
     */
    public String getBirthday() {
        return this.Birthday;
    }

    /**
     * Set Date of birth in Thai
     * @param Birthday Date of birth in Thai
     */
    public void setBirthday(String Birthday) {
        this.Birthday = Birthday;
    }

    /**
     * Get Date of birth in English 
     * @return EnBirthday Date of birth in English
     */
    public String getEnBirthday() {
        return this.EnBirthday;
    }

    /**
     * Set Date of birth in English
     * @param EnBirthday Date of birth in English
     */
    public void setEnBirthday(String EnBirthday) {
        this.EnBirthday = EnBirthday;
    }

    /**
     * Get Religion 
     * @return Religion Religion
     */
    public String getReligion() {
        return this.Religion;
    }

    /**
     * Set Religion
     * @param Religion Religion
     */
    public void setReligion(String Religion) {
        this.Religion = Religion;
    }

    /**
     * Get Serial number 
     * @return SerialNumber Serial number
     */
    public String getSerialNumber() {
        return this.SerialNumber;
    }

    /**
     * Set Serial number
     * @param SerialNumber Serial number
     */
    public void setSerialNumber(String SerialNumber) {
        this.SerialNumber = SerialNumber;
    }

    /**
     * Get Address 
     * @return Address Address
     */
    public String getAddress() {
        return this.Address;
    }

    /**
     * Set Address
     * @param Address Address
     */
    public void setAddress(String Address) {
        this.Address = Address;
    }

    /**
     * Get LaserID in the back of the card. 
     * @return LaserID LaserID in the back of the card.
     */
    public String getLaserID() {
        return this.LaserID;
    }

    /**
     * Set LaserID in the back of the card.
     * @param LaserID LaserID in the back of the card.
     */
    public void setLaserID(String LaserID) {
        this.LaserID = LaserID;
    }

    /**
     * Get Identity photo 
     * @return PortraitImage Identity photo
     */
    public String getPortraitImage() {
        return this.PortraitImage;
    }

    /**
     * Set Identity photo
     * @param PortraitImage Identity photo
     */
    public void setPortraitImage(String PortraitImage) {
        this.PortraitImage = PortraitImage;
    }

    /**
     * Get Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled. 
     * @return WarnCardInfos Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     */
    public Long [] getWarnCardInfos() {
        return this.WarnCardInfos;
    }

    /**
     * Set Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     * @param WarnCardInfos Card Warning Information

-9101 Alarm for covered certificate,
-9102 Alarm for photocopied certificate,
-9103 Alarm for photographed certificate,
-9104 Alarm for PS certificate,
-9107 Alarm for reflective certificate,
-9108 Alarm for blurry image,
-9109 This capability is not enabled.
     */
    public void setWarnCardInfos(Long [] WarnCardInfos) {
        this.WarnCardInfos = WarnCardInfos;
    }

    /**
     * Get This field is deprecated and will always return "1". Usage is not recommended. 
     * @return AdvancedInfo This field is deprecated and will always return "1". Usage is not recommended.
     * @deprecated
     */
    @Deprecated
    public String getAdvancedInfo() {
        return this.AdvancedInfo;
    }

    /**
     * Set This field is deprecated and will always return "1". Usage is not recommended.
     * @param AdvancedInfo This field is deprecated and will always return "1". Usage is not recommended.
     * @deprecated
     */
    @Deprecated
    public void setAdvancedInfo(String AdvancedInfo) {
        this.AdvancedInfo = AdvancedInfo;
    }

    /**
     * Get The number of cards detected in the input image provided via ImageBase64 parameter.(Currently supported only in ap-bangkok region) 
     * @return CardCount The number of cards detected in the input image provided via ImageBase64 parameter.(Currently supported only in ap-bangkok region)
     */
    public Long getCardCount() {
        return this.CardCount;
    }

    /**
     * Set The number of cards detected in the input image provided via ImageBase64 parameter.(Currently supported only in ap-bangkok region)
     * @param CardCount The number of cards detected in the input image provided via ImageBase64 parameter.(Currently supported only in ap-bangkok region)
     */
    public void setCardCount(Long CardCount) {
        this.CardCount = CardCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecognizeThaiIDCardOCRResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecognizeThaiIDCardOCRResponse(RecognizeThaiIDCardOCRResponse source) {
        if (source.ID != null) {
            this.ID = new String(source.ID);
        }
        if (source.ThaiName != null) {
            this.ThaiName = new String(source.ThaiName);
        }
        if (source.EnFirstName != null) {
            this.EnFirstName = new String(source.EnFirstName);
        }
        if (source.EnLastName != null) {
            this.EnLastName = new String(source.EnLastName);
        }
        if (source.IssueDate != null) {
            this.IssueDate = new String(source.IssueDate);
        }
        if (source.ExpirationDate != null) {
            this.ExpirationDate = new String(source.ExpirationDate);
        }
        if (source.EnIssueDate != null) {
            this.EnIssueDate = new String(source.EnIssueDate);
        }
        if (source.EnExpirationDate != null) {
            this.EnExpirationDate = new String(source.EnExpirationDate);
        }
        if (source.Birthday != null) {
            this.Birthday = new String(source.Birthday);
        }
        if (source.EnBirthday != null) {
            this.EnBirthday = new String(source.EnBirthday);
        }
        if (source.Religion != null) {
            this.Religion = new String(source.Religion);
        }
        if (source.SerialNumber != null) {
            this.SerialNumber = new String(source.SerialNumber);
        }
        if (source.Address != null) {
            this.Address = new String(source.Address);
        }
        if (source.LaserID != null) {
            this.LaserID = new String(source.LaserID);
        }
        if (source.PortraitImage != null) {
            this.PortraitImage = new String(source.PortraitImage);
        }
        if (source.WarnCardInfos != null) {
            this.WarnCardInfos = new Long[source.WarnCardInfos.length];
            for (int i = 0; i < source.WarnCardInfos.length; i++) {
                this.WarnCardInfos[i] = new Long(source.WarnCardInfos[i]);
            }
        }
        if (source.AdvancedInfo != null) {
            this.AdvancedInfo = new String(source.AdvancedInfo);
        }
        if (source.CardCount != null) {
            this.CardCount = new Long(source.CardCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ID", this.ID);
        this.setParamSimple(map, prefix + "ThaiName", this.ThaiName);
        this.setParamSimple(map, prefix + "EnFirstName", this.EnFirstName);
        this.setParamSimple(map, prefix + "EnLastName", this.EnLastName);
        this.setParamSimple(map, prefix + "IssueDate", this.IssueDate);
        this.setParamSimple(map, prefix + "ExpirationDate", this.ExpirationDate);
        this.setParamSimple(map, prefix + "EnIssueDate", this.EnIssueDate);
        this.setParamSimple(map, prefix + "EnExpirationDate", this.EnExpirationDate);
        this.setParamSimple(map, prefix + "Birthday", this.Birthday);
        this.setParamSimple(map, prefix + "EnBirthday", this.EnBirthday);
        this.setParamSimple(map, prefix + "Religion", this.Religion);
        this.setParamSimple(map, prefix + "SerialNumber", this.SerialNumber);
        this.setParamSimple(map, prefix + "Address", this.Address);
        this.setParamSimple(map, prefix + "LaserID", this.LaserID);
        this.setParamSimple(map, prefix + "PortraitImage", this.PortraitImage);
        this.setParamArraySimple(map, prefix + "WarnCardInfos.", this.WarnCardInfos);
        this.setParamSimple(map, prefix + "AdvancedInfo", this.AdvancedInfo);
        this.setParamSimple(map, prefix + "CardCount", this.CardCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

