/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.omics.v20221128.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetRunMetadataFileResponse extends AbstractModel {

    /**
    * Document pre-signed link that works in a minute
    */
    @SerializedName("CosSignedUrl")
    @Expose
    private String CosSignedUrl;

    /**
    * Batch document pre-signed link that works in a minute
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("CosSignedUrls")
    @Expose
    private String [] CosSignedUrls;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Document pre-signed link that works in a minute 
     * @return CosSignedUrl Document pre-signed link that works in a minute
     */
    public String getCosSignedUrl() {
        return this.CosSignedUrl;
    }

    /**
     * Set Document pre-signed link that works in a minute
     * @param CosSignedUrl Document pre-signed link that works in a minute
     */
    public void setCosSignedUrl(String CosSignedUrl) {
        this.CosSignedUrl = CosSignedUrl;
    }

    /**
     * Get Batch document pre-signed link that works in a minute
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return CosSignedUrls Batch document pre-signed link that works in a minute
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getCosSignedUrls() {
        return this.CosSignedUrls;
    }

    /**
     * Set Batch document pre-signed link that works in a minute
Note: This field may return null, indicating that no valid values can be obtained.
     * @param CosSignedUrls Batch document pre-signed link that works in a minute
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setCosSignedUrls(String [] CosSignedUrls) {
        this.CosSignedUrls = CosSignedUrls;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetRunMetadataFileResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetRunMetadataFileResponse(GetRunMetadataFileResponse source) {
        if (source.CosSignedUrl != null) {
            this.CosSignedUrl = new String(source.CosSignedUrl);
        }
        if (source.CosSignedUrls != null) {
            this.CosSignedUrls = new String[source.CosSignedUrls.length];
            for (int i = 0; i < source.CosSignedUrls.length; i++) {
                this.CosSignedUrls[i] = new String(source.CosSignedUrls[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CosSignedUrl", this.CosSignedUrl);
        this.setParamArraySimple(map, prefix + "CosSignedUrls.", this.CosSignedUrls);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

