/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.organization.v20210331.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIdentityCenterResponse extends AbstractModel {

    /**
    * Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
    */
    @SerializedName("ZoneId")
    @Expose
    private String ZoneId;

    /**
    * Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
    */
    @SerializedName("ZoneName")
    @Expose
    private String ZoneName;

    /**
    * Service activation status. Disabled: not activated; Enabled: activated.
    */
    @SerializedName("ServiceStatus")
    @Expose
    private String ServiceStatus;

    /**
    * SCIM synchronization status. Enabled: enabled. Disabled: disabled.
    */
    @SerializedName("ScimSyncStatus")
    @Expose
    private String ScimSyncStatus;

    /**
    * Creation time
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * Update date
    */
    @SerializedName("UpdateTime")
    @Expose
    private String UpdateTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters. 
     * @return ZoneId Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
     */
    public String getZoneId() {
        return this.ZoneId;
    }

    /**
     * Set Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
     * @param ZoneId Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
     */
    public void setZoneId(String ZoneId) {
        this.ZoneId = ZoneId;
    }

    /**
     * Get Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-). 
     * @return ZoneName Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
     */
    public String getZoneName() {
        return this.ZoneName;
    }

    /**
     * Set Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
     * @param ZoneName Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
     */
    public void setZoneName(String ZoneName) {
        this.ZoneName = ZoneName;
    }

    /**
     * Get Service activation status. Disabled: not activated; Enabled: activated. 
     * @return ServiceStatus Service activation status. Disabled: not activated; Enabled: activated.
     */
    public String getServiceStatus() {
        return this.ServiceStatus;
    }

    /**
     * Set Service activation status. Disabled: not activated; Enabled: activated.
     * @param ServiceStatus Service activation status. Disabled: not activated; Enabled: activated.
     */
    public void setServiceStatus(String ServiceStatus) {
        this.ServiceStatus = ServiceStatus;
    }

    /**
     * Get SCIM synchronization status. Enabled: enabled. Disabled: disabled. 
     * @return ScimSyncStatus SCIM synchronization status. Enabled: enabled. Disabled: disabled.
     */
    public String getScimSyncStatus() {
        return this.ScimSyncStatus;
    }

    /**
     * Set SCIM synchronization status. Enabled: enabled. Disabled: disabled.
     * @param ScimSyncStatus SCIM synchronization status. Enabled: enabled. Disabled: disabled.
     */
    public void setScimSyncStatus(String ScimSyncStatus) {
        this.ScimSyncStatus = ScimSyncStatus;
    }

    /**
     * Get Creation time 
     * @return CreateTime Creation time
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set Creation time
     * @param CreateTime Creation time
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get Update date 
     * @return UpdateTime Update date
     */
    public String getUpdateTime() {
        return this.UpdateTime;
    }

    /**
     * Set Update date
     * @param UpdateTime Update date
     */
    public void setUpdateTime(String UpdateTime) {
        this.UpdateTime = UpdateTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeIdentityCenterResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIdentityCenterResponse(DescribeIdentityCenterResponse source) {
        if (source.ZoneId != null) {
            this.ZoneId = new String(source.ZoneId);
        }
        if (source.ZoneName != null) {
            this.ZoneName = new String(source.ZoneName);
        }
        if (source.ServiceStatus != null) {
            this.ServiceStatus = new String(source.ServiceStatus);
        }
        if (source.ScimSyncStatus != null) {
            this.ScimSyncStatus = new String(source.ScimSyncStatus);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.UpdateTime != null) {
            this.UpdateTime = new String(source.UpdateTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ZoneId", this.ZoneId);
        this.setParamSimple(map, prefix + "ZoneName", this.ZoneName);
        this.setParamSimple(map, prefix + "ServiceStatus", this.ServiceStatus);
        this.setParamSimple(map, prefix + "ScimSyncStatus", this.ScimSyncStatus);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "UpdateTime", this.UpdateTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

