/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.organization.v20210331.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ListRoleConfigurationsResponse extends AbstractModel {

    /**
    * Total number of data entries that meet the request parameter conditions.
    */
    @SerializedName("TotalCounts")
    @Expose
    private Long TotalCounts;

    /**
    * Maximum number of data entries per page.
    */
    @SerializedName("MaxResults")
    @Expose
    private Long MaxResults;

    /**
    * Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
    */
    @SerializedName("IsTruncated")
    @Expose
    private Boolean IsTruncated;

    /**
    * Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
    */
    @SerializedName("NextToken")
    @Expose
    private String NextToken;

    /**
    * Permission configuration list.
    */
    @SerializedName("RoleConfigurations")
    @Expose
    private RoleConfiguration [] RoleConfigurations;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of data entries that meet the request parameter conditions. 
     * @return TotalCounts Total number of data entries that meet the request parameter conditions.
     */
    public Long getTotalCounts() {
        return this.TotalCounts;
    }

    /**
     * Set Total number of data entries that meet the request parameter conditions.
     * @param TotalCounts Total number of data entries that meet the request parameter conditions.
     */
    public void setTotalCounts(Long TotalCounts) {
        this.TotalCounts = TotalCounts;
    }

    /**
     * Get Maximum number of data entries per page. 
     * @return MaxResults Maximum number of data entries per page.
     */
    public Long getMaxResults() {
        return this.MaxResults;
    }

    /**
     * Set Maximum number of data entries per page.
     * @param MaxResults Maximum number of data entries per page.
     */
    public void setMaxResults(Long MaxResults) {
        this.MaxResults = MaxResults;
    }

    /**
     * Get Whether the returned result is truncated. Valid values: true: truncated; false: not truncated. 
     * @return IsTruncated Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
     */
    public Boolean getIsTruncated() {
        return this.IsTruncated;
    }

    /**
     * Set Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
     * @param IsTruncated Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
     */
    public void setIsTruncated(Boolean IsTruncated) {
        this.IsTruncated = IsTruncated;
    }

    /**
     * Get Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true. 
     * @return NextToken Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
     */
    public String getNextToken() {
        return this.NextToken;
    }

    /**
     * Set Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
     * @param NextToken Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
     */
    public void setNextToken(String NextToken) {
        this.NextToken = NextToken;
    }

    /**
     * Get Permission configuration list. 
     * @return RoleConfigurations Permission configuration list.
     */
    public RoleConfiguration [] getRoleConfigurations() {
        return this.RoleConfigurations;
    }

    /**
     * Set Permission configuration list.
     * @param RoleConfigurations Permission configuration list.
     */
    public void setRoleConfigurations(RoleConfiguration [] RoleConfigurations) {
        this.RoleConfigurations = RoleConfigurations;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ListRoleConfigurationsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ListRoleConfigurationsResponse(ListRoleConfigurationsResponse source) {
        if (source.TotalCounts != null) {
            this.TotalCounts = new Long(source.TotalCounts);
        }
        if (source.MaxResults != null) {
            this.MaxResults = new Long(source.MaxResults);
        }
        if (source.IsTruncated != null) {
            this.IsTruncated = new Boolean(source.IsTruncated);
        }
        if (source.NextToken != null) {
            this.NextToken = new String(source.NextToken);
        }
        if (source.RoleConfigurations != null) {
            this.RoleConfigurations = new RoleConfiguration[source.RoleConfigurations.length];
            for (int i = 0; i < source.RoleConfigurations.length; i++) {
                this.RoleConfigurations[i] = new RoleConfiguration(source.RoleConfigurations[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCounts", this.TotalCounts);
        this.setParamSimple(map, prefix + "MaxResults", this.MaxResults);
        this.setParamSimple(map, prefix + "IsTruncated", this.IsTruncated);
        this.setParamSimple(map, prefix + "NextToken", this.NextToken);
        this.setParamArrayObj(map, prefix + "RoleConfigurations.", this.RoleConfigurations);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

