/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.organization.v20210331.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ListSCIMCredentialsResponse extends AbstractModel {

    /**
    * Number of SCIM keys.
    */
    @SerializedName("TotalCounts")
    @Expose
    private Long TotalCounts;

    /**
    * SCIM key information.
    */
    @SerializedName("SCIMCredentials")
    @Expose
    private SCIMCredential [] SCIMCredentials;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of SCIM keys. 
     * @return TotalCounts Number of SCIM keys.
     */
    public Long getTotalCounts() {
        return this.TotalCounts;
    }

    /**
     * Set Number of SCIM keys.
     * @param TotalCounts Number of SCIM keys.
     */
    public void setTotalCounts(Long TotalCounts) {
        this.TotalCounts = TotalCounts;
    }

    /**
     * Get SCIM key information. 
     * @return SCIMCredentials SCIM key information.
     */
    public SCIMCredential [] getSCIMCredentials() {
        return this.SCIMCredentials;
    }

    /**
     * Set SCIM key information.
     * @param SCIMCredentials SCIM key information.
     */
    public void setSCIMCredentials(SCIMCredential [] SCIMCredentials) {
        this.SCIMCredentials = SCIMCredentials;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ListSCIMCredentialsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ListSCIMCredentialsResponse(ListSCIMCredentialsResponse source) {
        if (source.TotalCounts != null) {
            this.TotalCounts = new Long(source.TotalCounts);
        }
        if (source.SCIMCredentials != null) {
            this.SCIMCredentials = new SCIMCredential[source.SCIMCredentials.length];
            for (int i = 0; i < source.SCIMCredentials.length; i++) {
                this.SCIMCredentials[i] = new SCIMCredential(source.SCIMCredentials[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCounts", this.TotalCounts);
        this.setParamArrayObj(map, prefix + "SCIMCredentials.", this.SCIMCredentials);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

