/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.privatedns.v20201028.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class AuditLogInfo extends AbstractModel {

    /**
    * Time
    */
    @SerializedName("Date")
    @Expose
    private String Date;

    /**
    * Operator UIN
    */
    @SerializedName("OperatorUin")
    @Expose
    private String OperatorUin;

    /**
    * Log content
    */
    @SerializedName("Content")
    @Expose
    private String Content;

    /**
     * Get Time 
     * @return Date Time
     */
    public String getDate() {
        return this.Date;
    }

    /**
     * Set Time
     * @param Date Time
     */
    public void setDate(String Date) {
        this.Date = Date;
    }

    /**
     * Get Operator UIN 
     * @return OperatorUin Operator UIN
     */
    public String getOperatorUin() {
        return this.OperatorUin;
    }

    /**
     * Set Operator UIN
     * @param OperatorUin Operator UIN
     */
    public void setOperatorUin(String OperatorUin) {
        this.OperatorUin = OperatorUin;
    }

    /**
     * Get Log content 
     * @return Content Log content
     */
    public String getContent() {
        return this.Content;
    }

    /**
     * Set Log content
     * @param Content Log content
     */
    public void setContent(String Content) {
        this.Content = Content;
    }

    public AuditLogInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public AuditLogInfo(AuditLogInfo source) {
        if (source.Date != null) {
            this.Date = new String(source.Date);
        }
        if (source.OperatorUin != null) {
            this.OperatorUin = new String(source.OperatorUin);
        }
        if (source.Content != null) {
            this.Content = new String(source.Content);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Date", this.Date);
        this.setParamSimple(map, prefix + "OperatorUin", this.OperatorUin);
        this.setParamSimple(map, prefix + "Content", this.Content);

    }
}

