/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.privatedns.v20201028.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeEndPointListResponse extends AbstractModel {

    /**
    * Total number of endpoints.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Endpoint list.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("EndPointSet")
    @Expose
    private EndPointInfo [] EndPointSet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of endpoints. 
     * @return TotalCount Total number of endpoints.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of endpoints.
     * @param TotalCount Total number of endpoints.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Endpoint list.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return EndPointSet Endpoint list.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public EndPointInfo [] getEndPointSet() {
        return this.EndPointSet;
    }

    /**
     * Set Endpoint list.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param EndPointSet Endpoint list.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setEndPointSet(EndPointInfo [] EndPointSet) {
        this.EndPointSet = EndPointSet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeEndPointListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeEndPointListResponse(DescribeEndPointListResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.EndPointSet != null) {
            this.EndPointSet = new EndPointInfo[source.EndPointSet.length];
            for (int i = 0; i < source.EndPointSet.length; i++) {
                this.EndPointSet[i] = new EndPointInfo(source.EndPointSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "EndPointSet.", this.EndPointSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

