/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.pts.v20210728.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCheckSummaryResponse extends AbstractModel {

    /**
    * Checkpoint summary information.

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("CheckSummarySet")
    @Expose
    private CheckSummary [] CheckSummarySet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Checkpoint summary information.

Note: This field may return null, indicating that no valid value is found. 
     * @return CheckSummarySet Checkpoint summary information.

Note: This field may return null, indicating that no valid value is found.
     */
    public CheckSummary [] getCheckSummarySet() {
        return this.CheckSummarySet;
    }

    /**
     * Set Checkpoint summary information.

Note: This field may return null, indicating that no valid value is found.
     * @param CheckSummarySet Checkpoint summary information.

Note: This field may return null, indicating that no valid value is found.
     */
    public void setCheckSummarySet(CheckSummary [] CheckSummarySet) {
        this.CheckSummarySet = CheckSummarySet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCheckSummaryResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCheckSummaryResponse(DescribeCheckSummaryResponse source) {
        if (source.CheckSummarySet != null) {
            this.CheckSummarySet = new CheckSummary[source.CheckSummarySet.length];
            for (int i = 0; i < source.CheckSummarySet.length; i++) {
                this.CheckSummarySet[i] = new CheckSummary(source.CheckSummarySet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "CheckSummarySet.", this.CheckSummarySet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

