/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.pts.v20210728.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSampleLogsResponse extends AbstractModel {

    /**
    * Total number of logs.
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("Context")
    @Expose
    private String Context;

    /**
    * Array of request logs.

Note: This field may return null, indicating that no valid value is found.
    */
    @SerializedName("SampleLogs")
    @Expose
    private SampleLog [] SampleLogs;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of logs. 
     * @return Total Total number of logs.
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set Total number of logs.
     * @param Total Total number of logs.
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
Note: This field may return null, indicating that no valid value is found. 
     * @return Context Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
Note: This field may return null, indicating that no valid value is found.
     */
    public String getContext() {
        return this.Context;
    }

    /**
     * Set Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
Note: This field may return null, indicating that no valid value is found.
     * @param Context Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
Note: This field may return null, indicating that no valid value is found.
     */
    public void setContext(String Context) {
        this.Context = Context;
    }

    /**
     * Get Array of request logs.

Note: This field may return null, indicating that no valid value is found. 
     * @return SampleLogs Array of request logs.

Note: This field may return null, indicating that no valid value is found.
     */
    public SampleLog [] getSampleLogs() {
        return this.SampleLogs;
    }

    /**
     * Set Array of request logs.

Note: This field may return null, indicating that no valid value is found.
     * @param SampleLogs Array of request logs.

Note: This field may return null, indicating that no valid value is found.
     */
    public void setSampleLogs(SampleLog [] SampleLogs) {
        this.SampleLogs = SampleLogs;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSampleLogsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSampleLogsResponse(DescribeSampleLogsResponse source) {
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.Context != null) {
            this.Context = new String(source.Context);
        }
        if (source.SampleLogs != null) {
            this.SampleLogs = new SampleLog[source.SampleLogs.length];
            for (int i = 0; i < source.SampleLogs.length; i++) {
                this.SampleLogs[i] = new SampleLog(source.SampleLogs[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamSimple(map, prefix + "Context", this.Context);
        this.setParamArrayObj(map, prefix + "SampleLogs.", this.SampleLogs);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

