/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBackupDetailResponse extends AbstractModel {

    /**
    * Backup ID.
    */
    @SerializedName("BackupId")
    @Expose
    private String BackupId;

    /**
    * Backup start time.
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * Backup end time.
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * Backup mode.

- 1: manual backup.
- 0: automatic backup.
    */
    @SerializedName("BackupType")
    @Expose
    private String BackupType;

    /**
    * Backup status.

- 1: The backup is locked by other processes.
- 2: The backup is normal and not locked by any processes.
- -1: The backup has expired.
- 3: The backup is being exported.
- 4: The backup is successfully exported.
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Backup remarks.
    */
    @SerializedName("Remark")
    @Expose
    private String Remark;

    /**
    * Whether the backup is locked.

- 0: not locked.
- 1: locked.
    */
    @SerializedName("Locked")
    @Expose
    private Long Locked;

    /**
    * Backup file size. Unit: byte.
    */
    @SerializedName("BackupSize")
    @Expose
    private Long BackupSize;

    /**
    * Instance type.
    */
    @SerializedName("InstanceType")
    @Expose
    private Long InstanceType;

    /**
    * Memory size of a single shard. Unit: MB.
    */
    @SerializedName("MemSize")
    @Expose
    private Long MemSize;

    /**
    * Number of shards.
    */
    @SerializedName("ShardNum")
    @Expose
    private Long ShardNum;

    /**
    * Number of replicas.
    */
    @SerializedName("ReplicasNum")
    @Expose
    private Long ReplicasNum;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Backup ID. 
     * @return BackupId Backup ID.
     */
    public String getBackupId() {
        return this.BackupId;
    }

    /**
     * Set Backup ID.
     * @param BackupId Backup ID.
     */
    public void setBackupId(String BackupId) {
        this.BackupId = BackupId;
    }

    /**
     * Get Backup start time. 
     * @return StartTime Backup start time.
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set Backup start time.
     * @param StartTime Backup start time.
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get Backup end time. 
     * @return EndTime Backup end time.
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set Backup end time.
     * @param EndTime Backup end time.
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get Backup mode.

- 1: manual backup.
- 0: automatic backup. 
     * @return BackupType Backup mode.

- 1: manual backup.
- 0: automatic backup.
     */
    public String getBackupType() {
        return this.BackupType;
    }

    /**
     * Set Backup mode.

- 1: manual backup.
- 0: automatic backup.
     * @param BackupType Backup mode.

- 1: manual backup.
- 0: automatic backup.
     */
    public void setBackupType(String BackupType) {
        this.BackupType = BackupType;
    }

    /**
     * Get Backup status.

- 1: The backup is locked by other processes.
- 2: The backup is normal and not locked by any processes.
- -1: The backup has expired.
- 3: The backup is being exported.
- 4: The backup is successfully exported. 
     * @return Status Backup status.

- 1: The backup is locked by other processes.
- 2: The backup is normal and not locked by any processes.
- -1: The backup has expired.
- 3: The backup is being exported.
- 4: The backup is successfully exported.
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Backup status.

- 1: The backup is locked by other processes.
- 2: The backup is normal and not locked by any processes.
- -1: The backup has expired.
- 3: The backup is being exported.
- 4: The backup is successfully exported.
     * @param Status Backup status.

- 1: The backup is locked by other processes.
- 2: The backup is normal and not locked by any processes.
- -1: The backup has expired.
- 3: The backup is being exported.
- 4: The backup is successfully exported.
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Backup remarks. 
     * @return Remark Backup remarks.
     */
    public String getRemark() {
        return this.Remark;
    }

    /**
     * Set Backup remarks.
     * @param Remark Backup remarks.
     */
    public void setRemark(String Remark) {
        this.Remark = Remark;
    }

    /**
     * Get Whether the backup is locked.

- 0: not locked.
- 1: locked. 
     * @return Locked Whether the backup is locked.

- 0: not locked.
- 1: locked.
     */
    public Long getLocked() {
        return this.Locked;
    }

    /**
     * Set Whether the backup is locked.

- 0: not locked.
- 1: locked.
     * @param Locked Whether the backup is locked.

- 0: not locked.
- 1: locked.
     */
    public void setLocked(Long Locked) {
        this.Locked = Locked;
    }

    /**
     * Get Backup file size. Unit: byte. 
     * @return BackupSize Backup file size. Unit: byte.
     */
    public Long getBackupSize() {
        return this.BackupSize;
    }

    /**
     * Set Backup file size. Unit: byte.
     * @param BackupSize Backup file size. Unit: byte.
     */
    public void setBackupSize(Long BackupSize) {
        this.BackupSize = BackupSize;
    }

    /**
     * Get Instance type. 
     * @return InstanceType Instance type.
     */
    public Long getInstanceType() {
        return this.InstanceType;
    }

    /**
     * Set Instance type.
     * @param InstanceType Instance type.
     */
    public void setInstanceType(Long InstanceType) {
        this.InstanceType = InstanceType;
    }

    /**
     * Get Memory size of a single shard. Unit: MB. 
     * @return MemSize Memory size of a single shard. Unit: MB.
     */
    public Long getMemSize() {
        return this.MemSize;
    }

    /**
     * Set Memory size of a single shard. Unit: MB.
     * @param MemSize Memory size of a single shard. Unit: MB.
     */
    public void setMemSize(Long MemSize) {
        this.MemSize = MemSize;
    }

    /**
     * Get Number of shards. 
     * @return ShardNum Number of shards.
     */
    public Long getShardNum() {
        return this.ShardNum;
    }

    /**
     * Set Number of shards.
     * @param ShardNum Number of shards.
     */
    public void setShardNum(Long ShardNum) {
        this.ShardNum = ShardNum;
    }

    /**
     * Get Number of replicas. 
     * @return ReplicasNum Number of replicas.
     */
    public Long getReplicasNum() {
        return this.ReplicasNum;
    }

    /**
     * Set Number of replicas.
     * @param ReplicasNum Number of replicas.
     */
    public void setReplicasNum(Long ReplicasNum) {
        this.ReplicasNum = ReplicasNum;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBackupDetailResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBackupDetailResponse(DescribeBackupDetailResponse source) {
        if (source.BackupId != null) {
            this.BackupId = new String(source.BackupId);
        }
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.BackupType != null) {
            this.BackupType = new String(source.BackupType);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.Remark != null) {
            this.Remark = new String(source.Remark);
        }
        if (source.Locked != null) {
            this.Locked = new Long(source.Locked);
        }
        if (source.BackupSize != null) {
            this.BackupSize = new Long(source.BackupSize);
        }
        if (source.InstanceType != null) {
            this.InstanceType = new Long(source.InstanceType);
        }
        if (source.MemSize != null) {
            this.MemSize = new Long(source.MemSize);
        }
        if (source.ShardNum != null) {
            this.ShardNum = new Long(source.ShardNum);
        }
        if (source.ReplicasNum != null) {
            this.ReplicasNum = new Long(source.ReplicasNum);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "BackupId", this.BackupId);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "BackupType", this.BackupType);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "Remark", this.Remark);
        this.setParamSimple(map, prefix + "Locked", this.Locked);
        this.setParamSimple(map, prefix + "BackupSize", this.BackupSize);
        this.setParamSimple(map, prefix + "InstanceType", this.InstanceType);
        this.setParamSimple(map, prefix + "MemSize", this.MemSize);
        this.setParamSimple(map, prefix + "ShardNum", this.ShardNum);
        this.setParamSimple(map, prefix + "ReplicasNum", this.ReplicasNum);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

