/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDBSecurityGroupsResponse extends AbstractModel {

    /**
    * Security group rules
    */
    @SerializedName("Groups")
    @Expose
    private SecurityGroup [] Groups;

    /**
    * Private IPv4 address of an instance
    */
    @SerializedName("VIP")
    @Expose
    private String VIP;

    /**
    * Private network port
    */
    @SerializedName("VPort")
    @Expose
    private String VPort;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Security group rules 
     * @return Groups Security group rules
     */
    public SecurityGroup [] getGroups() {
        return this.Groups;
    }

    /**
     * Set Security group rules
     * @param Groups Security group rules
     */
    public void setGroups(SecurityGroup [] Groups) {
        this.Groups = Groups;
    }

    /**
     * Get Private IPv4 address of an instance 
     * @return VIP Private IPv4 address of an instance
     */
    public String getVIP() {
        return this.VIP;
    }

    /**
     * Set Private IPv4 address of an instance
     * @param VIP Private IPv4 address of an instance
     */
    public void setVIP(String VIP) {
        this.VIP = VIP;
    }

    /**
     * Get Private network port 
     * @return VPort Private network port
     */
    public String getVPort() {
        return this.VPort;
    }

    /**
     * Set Private network port
     * @param VPort Private network port
     */
    public void setVPort(String VPort) {
        this.VPort = VPort;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDBSecurityGroupsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDBSecurityGroupsResponse(DescribeDBSecurityGroupsResponse source) {
        if (source.Groups != null) {
            this.Groups = new SecurityGroup[source.Groups.length];
            for (int i = 0; i < source.Groups.length; i++) {
                this.Groups[i] = new SecurityGroup(source.Groups[i]);
            }
        }
        if (source.VIP != null) {
            this.VIP = new String(source.VIP);
        }
        if (source.VPort != null) {
            this.VPort = new String(source.VPort);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Groups.", this.Groups);
        this.setParamSimple(map, prefix + "VIP", this.VIP);
        this.setParamSimple(map, prefix + "VPort", this.VPort);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

