/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInstanceDTSInfoResponse extends AbstractModel {

    /**
    * DTS task ID.
    */
    @SerializedName("JobId")
    @Expose
    private String JobId;

    /**
    * DTS task name.
    */
    @SerializedName("JobName")
    @Expose
    private String JobName;

    /**
    * Task status. 1: creating (Creating); 3: checking (Checking); 4: check successful (CheckPass); 5: check failed (CheckNotPass); 7: task running (Running); 8: preparation completed (ReadyComplete); 9: task successful (Success); 10: task failed (Failed); 11: stopping (Stopping); 12: completing (Completing).
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Status description.
    */
    @SerializedName("StatusDesc")
    @Expose
    private String StatusDesc;

    /**
    * Synchronization delay. Unit: bytes.
    */
    @SerializedName("Offset")
    @Expose
    private Long Offset;

    /**
    * Disconnection time.
    */
    @SerializedName("CutDownTime")
    @Expose
    private String CutDownTime;

    /**
    * Source instance information.
    */
    @SerializedName("SrcInfo")
    @Expose
    private DescribeInstanceDTSInstanceInfo SrcInfo;

    /**
    * Destination instance information.
    */
    @SerializedName("DstInfo")
    @Expose
    private DescribeInstanceDTSInstanceInfo DstInfo;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get DTS task ID. 
     * @return JobId DTS task ID.
     */
    public String getJobId() {
        return this.JobId;
    }

    /**
     * Set DTS task ID.
     * @param JobId DTS task ID.
     */
    public void setJobId(String JobId) {
        this.JobId = JobId;
    }

    /**
     * Get DTS task name. 
     * @return JobName DTS task name.
     */
    public String getJobName() {
        return this.JobName;
    }

    /**
     * Set DTS task name.
     * @param JobName DTS task name.
     */
    public void setJobName(String JobName) {
        this.JobName = JobName;
    }

    /**
     * Get Task status. 1: creating (Creating); 3: checking (Checking); 4: check successful (CheckPass); 5: check failed (CheckNotPass); 7: task running (Running); 8: preparation completed (ReadyComplete); 9: task successful (Success); 10: task failed (Failed); 11: stopping (Stopping); 12: completing (Completing). 
     * @return Status Task status. 1: creating (Creating); 3: checking (Checking); 4: check successful (CheckPass); 5: check failed (CheckNotPass); 7: task running (Running); 8: preparation completed (ReadyComplete); 9: task successful (Success); 10: task failed (Failed); 11: stopping (Stopping); 12: completing (Completing).
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Task status. 1: creating (Creating); 3: checking (Checking); 4: check successful (CheckPass); 5: check failed (CheckNotPass); 7: task running (Running); 8: preparation completed (ReadyComplete); 9: task successful (Success); 10: task failed (Failed); 11: stopping (Stopping); 12: completing (Completing).
     * @param Status Task status. 1: creating (Creating); 3: checking (Checking); 4: check successful (CheckPass); 5: check failed (CheckNotPass); 7: task running (Running); 8: preparation completed (ReadyComplete); 9: task successful (Success); 10: task failed (Failed); 11: stopping (Stopping); 12: completing (Completing).
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Status description. 
     * @return StatusDesc Status description.
     */
    public String getStatusDesc() {
        return this.StatusDesc;
    }

    /**
     * Set Status description.
     * @param StatusDesc Status description.
     */
    public void setStatusDesc(String StatusDesc) {
        this.StatusDesc = StatusDesc;
    }

    /**
     * Get Synchronization delay. Unit: bytes. 
     * @return Offset Synchronization delay. Unit: bytes.
     */
    public Long getOffset() {
        return this.Offset;
    }

    /**
     * Set Synchronization delay. Unit: bytes.
     * @param Offset Synchronization delay. Unit: bytes.
     */
    public void setOffset(Long Offset) {
        this.Offset = Offset;
    }

    /**
     * Get Disconnection time. 
     * @return CutDownTime Disconnection time.
     */
    public String getCutDownTime() {
        return this.CutDownTime;
    }

    /**
     * Set Disconnection time.
     * @param CutDownTime Disconnection time.
     */
    public void setCutDownTime(String CutDownTime) {
        this.CutDownTime = CutDownTime;
    }

    /**
     * Get Source instance information. 
     * @return SrcInfo Source instance information.
     */
    public DescribeInstanceDTSInstanceInfo getSrcInfo() {
        return this.SrcInfo;
    }

    /**
     * Set Source instance information.
     * @param SrcInfo Source instance information.
     */
    public void setSrcInfo(DescribeInstanceDTSInstanceInfo SrcInfo) {
        this.SrcInfo = SrcInfo;
    }

    /**
     * Get Destination instance information. 
     * @return DstInfo Destination instance information.
     */
    public DescribeInstanceDTSInstanceInfo getDstInfo() {
        return this.DstInfo;
    }

    /**
     * Set Destination instance information.
     * @param DstInfo Destination instance information.
     */
    public void setDstInfo(DescribeInstanceDTSInstanceInfo DstInfo) {
        this.DstInfo = DstInfo;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeInstanceDTSInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInstanceDTSInfoResponse(DescribeInstanceDTSInfoResponse source) {
        if (source.JobId != null) {
            this.JobId = new String(source.JobId);
        }
        if (source.JobName != null) {
            this.JobName = new String(source.JobName);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.StatusDesc != null) {
            this.StatusDesc = new String(source.StatusDesc);
        }
        if (source.Offset != null) {
            this.Offset = new Long(source.Offset);
        }
        if (source.CutDownTime != null) {
            this.CutDownTime = new String(source.CutDownTime);
        }
        if (source.SrcInfo != null) {
            this.SrcInfo = new DescribeInstanceDTSInstanceInfo(source.SrcInfo);
        }
        if (source.DstInfo != null) {
            this.DstInfo = new DescribeInstanceDTSInstanceInfo(source.DstInfo);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "JobId", this.JobId);
        this.setParamSimple(map, prefix + "JobName", this.JobName);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "StatusDesc", this.StatusDesc);
        this.setParamSimple(map, prefix + "Offset", this.Offset);
        this.setParamSimple(map, prefix + "CutDownTime", this.CutDownTime);
        this.setParamObj(map, prefix + "SrcInfo.", this.SrcInfo);
        this.setParamObj(map, prefix + "DstInfo.", this.DstInfo);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

