/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInstanceNodeInfoResponse extends AbstractModel {

    /**
    * The number of proxy nodes
    */
    @SerializedName("ProxyCount")
    @Expose
    private Long ProxyCount;

    /**
    * Proxy node information.
    */
    @SerializedName("Proxy")
    @Expose
    private ProxyNodes [] Proxy;

    /**
    * The number of Redis nodes
    */
    @SerializedName("RedisCount")
    @Expose
    private Long RedisCount;

    /**
    * TencentDB for Redis® node information.
    */
    @SerializedName("Redis")
    @Expose
    private RedisNodes [] Redis;

    /**
    * This parameter has been disused.
    */
    @SerializedName("TendisCount")
    @Expose
    private Long TendisCount;

    /**
    * This parameter is no longer used. Please ignore it.
    */
    @SerializedName("Tendis")
    @Expose
    private TendisNodes [] Tendis;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get The number of proxy nodes 
     * @return ProxyCount The number of proxy nodes
     */
    public Long getProxyCount() {
        return this.ProxyCount;
    }

    /**
     * Set The number of proxy nodes
     * @param ProxyCount The number of proxy nodes
     */
    public void setProxyCount(Long ProxyCount) {
        this.ProxyCount = ProxyCount;
    }

    /**
     * Get Proxy node information. 
     * @return Proxy Proxy node information.
     */
    public ProxyNodes [] getProxy() {
        return this.Proxy;
    }

    /**
     * Set Proxy node information.
     * @param Proxy Proxy node information.
     */
    public void setProxy(ProxyNodes [] Proxy) {
        this.Proxy = Proxy;
    }

    /**
     * Get The number of Redis nodes 
     * @return RedisCount The number of Redis nodes
     */
    public Long getRedisCount() {
        return this.RedisCount;
    }

    /**
     * Set The number of Redis nodes
     * @param RedisCount The number of Redis nodes
     */
    public void setRedisCount(Long RedisCount) {
        this.RedisCount = RedisCount;
    }

    /**
     * Get TencentDB for Redis® node information. 
     * @return Redis TencentDB for Redis® node information.
     */
    public RedisNodes [] getRedis() {
        return this.Redis;
    }

    /**
     * Set TencentDB for Redis® node information.
     * @param Redis TencentDB for Redis® node information.
     */
    public void setRedis(RedisNodes [] Redis) {
        this.Redis = Redis;
    }

    /**
     * Get This parameter has been disused. 
     * @return TendisCount This parameter has been disused.
     */
    public Long getTendisCount() {
        return this.TendisCount;
    }

    /**
     * Set This parameter has been disused.
     * @param TendisCount This parameter has been disused.
     */
    public void setTendisCount(Long TendisCount) {
        this.TendisCount = TendisCount;
    }

    /**
     * Get This parameter is no longer used. Please ignore it. 
     * @return Tendis This parameter is no longer used. Please ignore it.
     */
    public TendisNodes [] getTendis() {
        return this.Tendis;
    }

    /**
     * Set This parameter is no longer used. Please ignore it.
     * @param Tendis This parameter is no longer used. Please ignore it.
     */
    public void setTendis(TendisNodes [] Tendis) {
        this.Tendis = Tendis;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeInstanceNodeInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInstanceNodeInfoResponse(DescribeInstanceNodeInfoResponse source) {
        if (source.ProxyCount != null) {
            this.ProxyCount = new Long(source.ProxyCount);
        }
        if (source.Proxy != null) {
            this.Proxy = new ProxyNodes[source.Proxy.length];
            for (int i = 0; i < source.Proxy.length; i++) {
                this.Proxy[i] = new ProxyNodes(source.Proxy[i]);
            }
        }
        if (source.RedisCount != null) {
            this.RedisCount = new Long(source.RedisCount);
        }
        if (source.Redis != null) {
            this.Redis = new RedisNodes[source.Redis.length];
            for (int i = 0; i < source.Redis.length; i++) {
                this.Redis[i] = new RedisNodes(source.Redis[i]);
            }
        }
        if (source.TendisCount != null) {
            this.TendisCount = new Long(source.TendisCount);
        }
        if (source.Tendis != null) {
            this.Tendis = new TendisNodes[source.Tendis.length];
            for (int i = 0; i < source.Tendis.length; i++) {
                this.Tendis[i] = new TendisNodes(source.Tendis[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ProxyCount", this.ProxyCount);
        this.setParamArrayObj(map, prefix + "Proxy.", this.Proxy);
        this.setParamSimple(map, prefix + "RedisCount", this.RedisCount);
        this.setParamArrayObj(map, prefix + "Redis.", this.Redis);
        this.setParamSimple(map, prefix + "TendisCount", this.TendisCount);
        this.setParamArrayObj(map, prefix + "Tendis.", this.Tendis);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

