/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMaintenanceWindowResponse extends AbstractModel {

    /**
    * Start time of the maintenance window. Value range: any time point between 00:00 and 23:00, for example, 03:24.
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * End time of the maintenance window.
- Value range: any time point between 00:00 and 23:00, for example, 04:24.
- The minimum maintenance duration is 30 minutes and the maximum is 3 hours.
- The end time should be later than the start time.
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Start time of the maintenance window. Value range: any time point between 00:00 and 23:00, for example, 03:24. 
     * @return StartTime Start time of the maintenance window. Value range: any time point between 00:00 and 23:00, for example, 03:24.
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set Start time of the maintenance window. Value range: any time point between 00:00 and 23:00, for example, 03:24.
     * @param StartTime Start time of the maintenance window. Value range: any time point between 00:00 and 23:00, for example, 03:24.
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get End time of the maintenance window.
- Value range: any time point between 00:00 and 23:00, for example, 04:24.
- The minimum maintenance duration is 30 minutes and the maximum is 3 hours.
- The end time should be later than the start time. 
     * @return EndTime End time of the maintenance window.
- Value range: any time point between 00:00 and 23:00, for example, 04:24.
- The minimum maintenance duration is 30 minutes and the maximum is 3 hours.
- The end time should be later than the start time.
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set End time of the maintenance window.
- Value range: any time point between 00:00 and 23:00, for example, 04:24.
- The minimum maintenance duration is 30 minutes and the maximum is 3 hours.
- The end time should be later than the start time.
     * @param EndTime End time of the maintenance window.
- Value range: any time point between 00:00 and 23:00, for example, 04:24.
- The minimum maintenance duration is 30 minutes and the maximum is 3 hours.
- The end time should be later than the start time.
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMaintenanceWindowResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMaintenanceWindowResponse(DescribeMaintenanceWindowResponse source) {
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

