/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeReplicationGroupInstanceResponse extends AbstractModel {

    /**
    * AppID。
    */
    @SerializedName("AppId")
    @Expose
    private Long AppId;

    /**
    * Numerical code of a region.
    */
    @SerializedName("RegionId")
    @Expose
    private Long RegionId;

    /**
    * String ID of a replication group.
    */
    @SerializedName("GroupId")
    @Expose
    private String GroupId;

    /**
    * Replication group name.
    */
    @SerializedName("GroupName")
    @Expose
    private String GroupName;

    /**
    * Instance replication group role.
- r: secondary instance.
- rw: primary instance.
    */
    @SerializedName("InstanceRole")
    @Expose
    private String InstanceRole;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get AppID。 
     * @return AppId AppID。
     */
    public Long getAppId() {
        return this.AppId;
    }

    /**
     * Set AppID。
     * @param AppId AppID。
     */
    public void setAppId(Long AppId) {
        this.AppId = AppId;
    }

    /**
     * Get Numerical code of a region. 
     * @return RegionId Numerical code of a region.
     */
    public Long getRegionId() {
        return this.RegionId;
    }

    /**
     * Set Numerical code of a region.
     * @param RegionId Numerical code of a region.
     */
    public void setRegionId(Long RegionId) {
        this.RegionId = RegionId;
    }

    /**
     * Get String ID of a replication group. 
     * @return GroupId String ID of a replication group.
     */
    public String getGroupId() {
        return this.GroupId;
    }

    /**
     * Set String ID of a replication group.
     * @param GroupId String ID of a replication group.
     */
    public void setGroupId(String GroupId) {
        this.GroupId = GroupId;
    }

    /**
     * Get Replication group name. 
     * @return GroupName Replication group name.
     */
    public String getGroupName() {
        return this.GroupName;
    }

    /**
     * Set Replication group name.
     * @param GroupName Replication group name.
     */
    public void setGroupName(String GroupName) {
        this.GroupName = GroupName;
    }

    /**
     * Get Instance replication group role.
- r: secondary instance.
- rw: primary instance. 
     * @return InstanceRole Instance replication group role.
- r: secondary instance.
- rw: primary instance.
     */
    public String getInstanceRole() {
        return this.InstanceRole;
    }

    /**
     * Set Instance replication group role.
- r: secondary instance.
- rw: primary instance.
     * @param InstanceRole Instance replication group role.
- r: secondary instance.
- rw: primary instance.
     */
    public void setInstanceRole(String InstanceRole) {
        this.InstanceRole = InstanceRole;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeReplicationGroupInstanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeReplicationGroupInstanceResponse(DescribeReplicationGroupInstanceResponse source) {
        if (source.AppId != null) {
            this.AppId = new Long(source.AppId);
        }
        if (source.RegionId != null) {
            this.RegionId = new Long(source.RegionId);
        }
        if (source.GroupId != null) {
            this.GroupId = new String(source.GroupId);
        }
        if (source.GroupName != null) {
            this.GroupName = new String(source.GroupName);
        }
        if (source.InstanceRole != null) {
            this.InstanceRole = new String(source.InstanceRole);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AppId", this.AppId);
        this.setParamSimple(map, prefix + "RegionId", this.RegionId);
        this.setParamSimple(map, prefix + "GroupId", this.GroupId);
        this.setParamSimple(map, prefix + "GroupName", this.GroupName);
        this.setParamSimple(map, prefix + "InstanceRole", this.InstanceRole);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

