/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSecondLevelBackupInfoResponse extends AbstractModel {

    /**
    * Backup record ID.
    */
    @SerializedName("BackupId")
    @Expose
    private String BackupId;

    /**
    * Backup timestamp.
    */
    @SerializedName("BackupTimestamp")
    @Expose
    private Long BackupTimestamp;

    /**
    * Timestamp range within which backup is missing.
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("MissingTimestamps")
    @Expose
    private SecondLevelBackupMissingTimestamps [] MissingTimestamps;

    /**
    * Timestamp when second-level backup is enabled for the instance.
    */
    @SerializedName("StartTimestamp")
    @Expose
    private Long StartTimestamp;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Backup record ID. 
     * @return BackupId Backup record ID.
     */
    public String getBackupId() {
        return this.BackupId;
    }

    /**
     * Set Backup record ID.
     * @param BackupId Backup record ID.
     */
    public void setBackupId(String BackupId) {
        this.BackupId = BackupId;
    }

    /**
     * Get Backup timestamp. 
     * @return BackupTimestamp Backup timestamp.
     */
    public Long getBackupTimestamp() {
        return this.BackupTimestamp;
    }

    /**
     * Set Backup timestamp.
     * @param BackupTimestamp Backup timestamp.
     */
    public void setBackupTimestamp(Long BackupTimestamp) {
        this.BackupTimestamp = BackupTimestamp;
    }

    /**
     * Get Timestamp range within which backup is missing.
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return MissingTimestamps Timestamp range within which backup is missing.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public SecondLevelBackupMissingTimestamps [] getMissingTimestamps() {
        return this.MissingTimestamps;
    }

    /**
     * Set Timestamp range within which backup is missing.
Note: This field may return null, indicating that no valid value can be obtained.
     * @param MissingTimestamps Timestamp range within which backup is missing.
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setMissingTimestamps(SecondLevelBackupMissingTimestamps [] MissingTimestamps) {
        this.MissingTimestamps = MissingTimestamps;
    }

    /**
     * Get Timestamp when second-level backup is enabled for the instance. 
     * @return StartTimestamp Timestamp when second-level backup is enabled for the instance.
     */
    public Long getStartTimestamp() {
        return this.StartTimestamp;
    }

    /**
     * Set Timestamp when second-level backup is enabled for the instance.
     * @param StartTimestamp Timestamp when second-level backup is enabled for the instance.
     */
    public void setStartTimestamp(Long StartTimestamp) {
        this.StartTimestamp = StartTimestamp;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSecondLevelBackupInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSecondLevelBackupInfoResponse(DescribeSecondLevelBackupInfoResponse source) {
        if (source.BackupId != null) {
            this.BackupId = new String(source.BackupId);
        }
        if (source.BackupTimestamp != null) {
            this.BackupTimestamp = new Long(source.BackupTimestamp);
        }
        if (source.MissingTimestamps != null) {
            this.MissingTimestamps = new SecondLevelBackupMissingTimestamps[source.MissingTimestamps.length];
            for (int i = 0; i < source.MissingTimestamps.length; i++) {
                this.MissingTimestamps[i] = new SecondLevelBackupMissingTimestamps(source.MissingTimestamps[i]);
            }
        }
        if (source.StartTimestamp != null) {
            this.StartTimestamp = new Long(source.StartTimestamp);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "BackupId", this.BackupId);
        this.setParamSimple(map, prefix + "BackupTimestamp", this.BackupTimestamp);
        this.setParamArrayObj(map, prefix + "MissingTimestamps.", this.MissingTimestamps);
        this.setParamSimple(map, prefix + "StartTimestamp", this.StartTimestamp);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

