/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InquiryPriceCreateInstanceResponse extends AbstractModel {

    /**
    * Price.
    */
    @SerializedName("Price")
    @Expose
    private Float Price;

    /**
    * High precision price. 
    */
    @SerializedName("HighPrecisionPrice")
    @Expose
    private Float HighPrecisionPrice;

    /**
    * Currency.
    */
    @SerializedName("Currency")
    @Expose
    private String Currency;

    /**
    * Price unit.

 - pent: cent.
 - microPent: microcent.
    */
    @SerializedName("AmountUnit")
    @Expose
    private String AmountUnit;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Price. 
     * @return Price Price.
     */
    public Float getPrice() {
        return this.Price;
    }

    /**
     * Set Price.
     * @param Price Price.
     */
    public void setPrice(Float Price) {
        this.Price = Price;
    }

    /**
     * Get High precision price.  
     * @return HighPrecisionPrice High precision price. 
     */
    public Float getHighPrecisionPrice() {
        return this.HighPrecisionPrice;
    }

    /**
     * Set High precision price. 
     * @param HighPrecisionPrice High precision price. 
     */
    public void setHighPrecisionPrice(Float HighPrecisionPrice) {
        this.HighPrecisionPrice = HighPrecisionPrice;
    }

    /**
     * Get Currency. 
     * @return Currency Currency.
     */
    public String getCurrency() {
        return this.Currency;
    }

    /**
     * Set Currency.
     * @param Currency Currency.
     */
    public void setCurrency(String Currency) {
        this.Currency = Currency;
    }

    /**
     * Get Price unit.

 - pent: cent.
 - microPent: microcent. 
     * @return AmountUnit Price unit.

 - pent: cent.
 - microPent: microcent.
     */
    public String getAmountUnit() {
        return this.AmountUnit;
    }

    /**
     * Set Price unit.

 - pent: cent.
 - microPent: microcent.
     * @param AmountUnit Price unit.

 - pent: cent.
 - microPent: microcent.
     */
    public void setAmountUnit(String AmountUnit) {
        this.AmountUnit = AmountUnit;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public InquiryPriceCreateInstanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InquiryPriceCreateInstanceResponse(InquiryPriceCreateInstanceResponse source) {
        if (source.Price != null) {
            this.Price = new Float(source.Price);
        }
        if (source.HighPrecisionPrice != null) {
            this.HighPrecisionPrice = new Float(source.HighPrecisionPrice);
        }
        if (source.Currency != null) {
            this.Currency = new String(source.Currency);
        }
        if (source.AmountUnit != null) {
            this.AmountUnit = new String(source.AmountUnit);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Price", this.Price);
        this.setParamSimple(map, prefix + "HighPrecisionPrice", this.HighPrecisionPrice);
        this.setParamSimple(map, prefix + "Currency", this.Currency);
        this.setParamSimple(map, prefix + "AmountUnit", this.AmountUnit);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

