/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ParameterDetail extends AbstractModel {

    /**
    * Parameter name
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Parameter Type
    */
    @SerializedName("ParamType")
    @Expose
    private String ParamType;

    /**
    * Default value of the parameter
    */
    @SerializedName("Default")
    @Expose
    private String Default;

    /**
    * Parameter description
    */
    @SerializedName("Description")
    @Expose
    private String Description;

    /**
    * Current value of the parameter
    */
    @SerializedName("CurrentValue")
    @Expose
    private String CurrentValue;

    /**
    * Whether to restart the database for the modified parameters to take effect
- `0`: No restart.
- `1`: Restart required.
    */
    @SerializedName("NeedReboot")
    @Expose
    private Long NeedReboot;

    /**
    * Maximum parameter value allowed.
    */
    @SerializedName("Max")
    @Expose
    private String Max;

    /**
    * Minimum parameter value allowed.
    */
    @SerializedName("Min")
    @Expose
    private String Min;

    /**
    * Optional enumeration values of a parameter. For non-enumeration parameters, it is empty.
    */
    @SerializedName("EnumValue")
    @Expose
    private String [] EnumValue;

    /**
     * Get Parameter name 
     * @return Name Parameter name
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Parameter name
     * @param Name Parameter name
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Parameter Type 
     * @return ParamType Parameter Type
     */
    public String getParamType() {
        return this.ParamType;
    }

    /**
     * Set Parameter Type
     * @param ParamType Parameter Type
     */
    public void setParamType(String ParamType) {
        this.ParamType = ParamType;
    }

    /**
     * Get Default value of the parameter 
     * @return Default Default value of the parameter
     */
    public String getDefault() {
        return this.Default;
    }

    /**
     * Set Default value of the parameter
     * @param Default Default value of the parameter
     */
    public void setDefault(String Default) {
        this.Default = Default;
    }

    /**
     * Get Parameter description 
     * @return Description Parameter description
     */
    public String getDescription() {
        return this.Description;
    }

    /**
     * Set Parameter description
     * @param Description Parameter description
     */
    public void setDescription(String Description) {
        this.Description = Description;
    }

    /**
     * Get Current value of the parameter 
     * @return CurrentValue Current value of the parameter
     */
    public String getCurrentValue() {
        return this.CurrentValue;
    }

    /**
     * Set Current value of the parameter
     * @param CurrentValue Current value of the parameter
     */
    public void setCurrentValue(String CurrentValue) {
        this.CurrentValue = CurrentValue;
    }

    /**
     * Get Whether to restart the database for the modified parameters to take effect
- `0`: No restart.
- `1`: Restart required. 
     * @return NeedReboot Whether to restart the database for the modified parameters to take effect
- `0`: No restart.
- `1`: Restart required.
     */
    public Long getNeedReboot() {
        return this.NeedReboot;
    }

    /**
     * Set Whether to restart the database for the modified parameters to take effect
- `0`: No restart.
- `1`: Restart required.
     * @param NeedReboot Whether to restart the database for the modified parameters to take effect
- `0`: No restart.
- `1`: Restart required.
     */
    public void setNeedReboot(Long NeedReboot) {
        this.NeedReboot = NeedReboot;
    }

    /**
     * Get Maximum parameter value allowed. 
     * @return Max Maximum parameter value allowed.
     */
    public String getMax() {
        return this.Max;
    }

    /**
     * Set Maximum parameter value allowed.
     * @param Max Maximum parameter value allowed.
     */
    public void setMax(String Max) {
        this.Max = Max;
    }

    /**
     * Get Minimum parameter value allowed. 
     * @return Min Minimum parameter value allowed.
     */
    public String getMin() {
        return this.Min;
    }

    /**
     * Set Minimum parameter value allowed.
     * @param Min Minimum parameter value allowed.
     */
    public void setMin(String Min) {
        this.Min = Min;
    }

    /**
     * Get Optional enumeration values of a parameter. For non-enumeration parameters, it is empty. 
     * @return EnumValue Optional enumeration values of a parameter. For non-enumeration parameters, it is empty.
     */
    public String [] getEnumValue() {
        return this.EnumValue;
    }

    /**
     * Set Optional enumeration values of a parameter. For non-enumeration parameters, it is empty.
     * @param EnumValue Optional enumeration values of a parameter. For non-enumeration parameters, it is empty.
     */
    public void setEnumValue(String [] EnumValue) {
        this.EnumValue = EnumValue;
    }

    public ParameterDetail() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ParameterDetail(ParameterDetail source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.ParamType != null) {
            this.ParamType = new String(source.ParamType);
        }
        if (source.Default != null) {
            this.Default = new String(source.Default);
        }
        if (source.Description != null) {
            this.Description = new String(source.Description);
        }
        if (source.CurrentValue != null) {
            this.CurrentValue = new String(source.CurrentValue);
        }
        if (source.NeedReboot != null) {
            this.NeedReboot = new Long(source.NeedReboot);
        }
        if (source.Max != null) {
            this.Max = new String(source.Max);
        }
        if (source.Min != null) {
            this.Min = new String(source.Min);
        }
        if (source.EnumValue != null) {
            this.EnumValue = new String[source.EnumValue.length];
            for (int i = 0; i < source.EnumValue.length; i++) {
                this.EnumValue[i] = new String(source.EnumValue[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "ParamType", this.ParamType);
        this.setParamSimple(map, prefix + "Default", this.Default);
        this.setParamSimple(map, prefix + "Description", this.Description);
        this.setParamSimple(map, prefix + "CurrentValue", this.CurrentValue);
        this.setParamSimple(map, prefix + "NeedReboot", this.NeedReboot);
        this.setParamSimple(map, prefix + "Max", this.Max);
        this.setParamSimple(map, prefix + "Min", this.Min);
        this.setParamArraySimple(map, prefix + "EnumValue.", this.EnumValue);

    }
}

